<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Company;
use App\Models\Supplier;
use App\Models\Demand;
use App\Models\Product;
use App\Models\Note;
class DemandController extends Controller
{
    public function showCompanyForm()
    {
        return view('company.create');
    }
    
    public function companyCreate(Request $request)
    {
        //dd($request->all());
        $validated = $request->validate([
            'company_name' => 'required|string',
            'company_phone' => 'required|string',
            'address' => 'nullable|string',
        ]);

        Company::create(
            [
                'company_name'=> $request->company_name,
                'company_phone'=>$request->company_phone,
                'address'=> $request->address,
            ]

            );
            return redirect()->route('company.show')->with('success', 'Company Added Successfully');
        }

    public function companyShow()
    
    {
        $companies= Company::all();
        return view('company.index', compact('companies'));
    }
    public function companySearch(Request $request)
    {
        $search = $request->input('search');
    
        $companies = Company::query()
            ->when(!is_null($search), function ($query) use ($search) {
                $query->where('company_name', 'like', "%{$search}%")
                      ->orWhere('company_phone', 'like', "%{$search}%")
                      ->orWhere('address', 'like', "%{$search}%");
                      
            })
            ->get();
    
        return view('company.index', compact('companies'));
    }
    

public function companyUpdate(Request $request, $id)
{
    $validated = $request->validate([
        'company_name' => 'required|string',
        'company_phone' => 'required|string',
        'address' => 'nullable|string',
    ]);

    $company = Company::findOrFail($id);
    $company->update($validated);

    return redirect()->route('company.show')->with('success', 'Company updated successfully.');
}
public function companyDelete($id)
{
    $company = Company::findOrFail($id);
    $company->delete();

    return redirect()->route('company.show')->with('success', 'Product deleted successfully.');
}
public function showdemandForm()
{
   
    return view('demand.create');
}
// public function demandShow()
// {
//     $companies = Company::all();
    
//     $demands = Demand::with('company')
//         ->when(request('company_filter'), function($query) {
//             return $query->where('company_id', request('company_filter'));
//         })
//         ->when(request('search'), function($query) {
//             return $query->where(function($q) {
//                 $q->where('product_name', 'like', '%'.request('search').'%')
//                   ->orWhere('supplier_name', 'like', '%'.request('search').'%');
//             });
//         })
//         ->get();
        
//     return view('demand.index', compact('demands', 'companies'));
// }
public function demandCreate(Request $request)
{
    //dd($request->all());
    $request->validate([
        'company_name' => 'nullable|string',
        'supplier_name' => 'nullable|string',
        'product_name' => 'nullable|string|max:255',
        'quantity' => 'nullable|integer|min:1',
        'reminder' => 'nullable|date',
    ]);

    Demand::create([
        'company_name' => $request->company_name,
        'supplier_name' => $request->supplier_name,
        'product_name' => $request->product_name,
        'qty' => $request->quantity,
        'reminder' => $request->reminder,
    ]);


    return redirect()->route('demand.show')->with('success', 'Demand submitted successfully.');
}
public function demandShow()
{
    // Get unique company names from demands table
    $companies = Demand::select('company_name')
        ->distinct()
        ->orderBy('company_name')
        ->pluck('company_name');

    $demands = Demand::query()
        ->when(request('company_filter'), function($query) {
            return $query->where('company_name', request('company_filter'));
        })
        ->when(request('search'), function($query) {
            $search = request('search');
            return $query->where(function($q) use ($search) {
                $q->where('product_name', 'like', '%'.$search.'%')
                  ->orWhere('supplier_name', 'like', '%'.$search.'%')
                  ->orWhere('company_name', 'like', '%'.$search.'%');
            });
        })
        ->orderBy('created_at', 'desc')
        ->get();
        
    return view('demand.index', compact('demands', 'companies'));
}

// Either remove this method completely or modify it to match demandShow
// public function searchDemand(Request $request)
// {
//     // This method can be removed since demandShow now handles searching
//     // Or keep it but make it consistent with demandShow:
//     $companies = Company::all();
//     $demands = Demand::with('company');

//     if ($search = $request->input('search')) {
//         $demands->where(function($query) use ($search) {
//             $query->where('product_name', 'like', "%{$search}%")
//                   ->orWhere('supplier_name', 'like', "%{$search}%")
//                   ->orWhereHas('company', function($q) use ($search) {
//                       $q->where('company_name', 'like', "%{$search}%");
//                   });
//         });
//     }

//     if ($companyFilter = $request->input('company_filter')) {
//         $demands->where('company_id', $companyFilter);
//     }

//     $demands = $demands->get();

//     return view('demand.index', compact('demands', 'companies'));
// }
public function demandDelete($id)
{
    $demand = Demand::findOrFail($id);
    $demand->delete();

    return redirect()->route('demand.show')->with('success', 'Product deleted successfully.');
}
public function noteView()
{
    return view('notes');
}
public function noteStore(Request $request)
{
    $request->validate([
        'title' => 'required|string|max:255',
        'note' => 'required|string',
    ]);

    Note::create($request->only('title', 'note'));

    return redirect()->back()->with('success', 'Note added successfully!');
}
public function noteShow()
    
{
    $notes= Note::all();
    return view('demand.noteShow', compact('notes'));
}
public function noteDelete($id)
{
    $note = Note::findOrFail($id);
    $note->delete();

    return redirect()->route('note.show')->with('success', 'Product deleted successfully.');
}
public function demandUpdate(Request $request, $id)
{
    //dd($request->all());
    $validated = $request->validate([
        'company_name' => 'required|string',
        'product_name' => 'required|string',
        'quantity' => 'nullable|string',
        'supplier_name' => 'required|string',
        'reminder' => 'required|date',
    ]);

    $demand = Demand::findOrFail($id);
    $demand->company_name= $request->company_name;
    $demand->product_name= $request->product_name;
    $demand->qty= $request->quantity;
    $demand->supplier_name= $request->supplier_name;
    $demand->reminder= $request->reminder;
    $demand->save();

    return redirect()->route('demand.show')->with('success', 'Demand updated successfully.');
}
public function noteUpdate(Request $request, $id)
{
    $validated = $request->validate([
        'title' => 'required|string',
        'note' => 'required|string',
    ]);

    $note = Note::findOrFail($id);
    $note->update($validated);

    return redirect()->route('note.show')->with('success', 'Note updated successfully.');
}
public function addFromProduct(Request $request, Product $product)
{
    try {
        $validated = $request->validate([
            'product_name' => 'required|string|max:255',
            'qty' => 'required|integer|min:1'
        ]);

        $demand = Demand::create([
            'product_name' => $validated['product_name'],
            'qty' => $validated['qty'],
            'company_name' => $product->company ?? '',
            'supplier_name' => '',
            'reminder' => null
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Product added to demand successfully!',
            'data' => $demand
        ], 201); // 201 Created status code

    } catch (\Illuminate\Validation\ValidationException $e) {
        return response()->json([
            'success' => false,
            'message' => 'Validation error',
            'errors' => $e->errors()
        ], 422);
        
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Server error: ' . $e->getMessage()
        ], 500);
    }
}
}
