<?php

namespace App\Http\Controllers;
use App\Models\Receipt;
use App\Models\ReceiptPrint;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class ReceiptController extends Controller
{
    public function showForm()
    {
        return view('receipt.form');
    }
      public function store(Request $request)
    {
        //dd($request->all());
        // Validate the request data
        $validatedData = $request->validate([
            'animal_tag_no' => 'nullable|string',
            'animal' => 'required|string',
            'gender' => 'required|string',
            'farmer_name' => 'nullable|string',
            'contact_no' => 'nullable|string',
            'referred_by' => 'nullable|string',
            'age' => 'nullable|string',
            'temperature' => 'nullable|numeric',
            'sample' => 'nullable|string',
            'pregnancy' => 'nullable|string',
            'pregnancy_month' => 'nullable|integer|min:1|max:12',
            'deworming' => 'nullable|string',
            'status' => 'nullable|string',
            'finding' => 'nullable|string',
             'diagnosis' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        // Create a new receipt
        $receipt = new Receipt();
        
        // Set current date and time
        $receipt->date = now()->format('Y-m-d');
        $receipt->time = now()->format('H:i:s');
        
        $nextId = \DB::table('receipts')->max('id') + 1;
        $receipt->patient_no = $nextId;
        
        $receipt->fill($validatedData);
        
        // Handle image upload
        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('receipt_images', 'public');
            $receipt->image = $imagePath;
        }
        
        $receipt->save();
        
       return redirect()->route('receipt.print', $receipt->id)->with('success', 'Bill submitted successfully!');
}

public function printView($id)
{
    $receipt = Receipt::findOrFail($id);
 $receiptPrint = ReceiptPrint::first();
    return view('receipt.print', compact('receipt','receiptPrint'));
}
    public function index(Request $request)
    {
        $search = $request->input('search');
        
        $receipts = Receipt::where('status', 'pending')->when($search, function ($query) use ($search) {
            return $query->where('patient_no', 'like', "%$search%")
                        ->orWhere('contact_no', 'like', "%$search%")
                        ->orWhere('farmer_name', 'like', "%$search%")
                        ->orWhere('animal_tag_no', 'like', "%$search%")
                         ->orWhere('animal', 'like', "%$search%");
        })
        ->orderBy('created_at', 'desc')
        ->paginate(10);

        return view('receipt.index', compact('receipts', 'search'));
    }

    public function complete(Request $request)
    {
        $search = $request->input('search');
        
        $receipts = Receipt::where('status', 'completed')->when($search, function ($query) use ($search) {
            return $query->where('patient_no', 'like', "%$search%")
                        ->orWhere('contact_no', 'like', "%$search%")
                        ->orWhere('farmer_name', 'like', "%$search%")
                        ->orWhere('animal_tag_no', 'like', "%$search%")
                         ->orWhere('animal', 'like', "%$search%");
        })
        ->orderBy('created_at', 'desc')
        ->paginate(10);

        return view('receipt.complete', compact('receipts', 'search'));
    }

    public function destroy($id)
    {
        $receipt=Receipt::findOrfail($id);
        $receipt->delete();
        return redirect()->back()->with('success', 'Receipt deleted successfully');
    }
     public function update(Request $request, $id)
    {
       //dd($request->all());
        $validatedData = $request->validate([
            'finding' => 'required|string',
             'diagnosis' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
      $receipt= Receipt::findOrfail($id);
      $receipt->finding=$request->finding;
        $receipt->diagnosis=$request->diagnosis;

        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('receipt_images', 'public');
            $receipt->image = $imagePath;
        }
            $receipt->save();


           return redirect()->route('receipt.completeprint', $receipt->id)->with('success', 'Bill submitted successfully!');


    }
 public function CompleteprintView($id)
{
    $receipt = Receipt::findOrFail($id);
 $receiptPrint = ReceiptPrint::first();
    // Update the status to "completed"
    $receipt->status = 'completed';
    $receipt->save();

    return view('receipt.completeprint', compact('receipt', 'receiptPrint'));
}

}
