<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Receipt extends Model
{
    use HasFactory;

    protected $fillable = [
       'patient_no',
        'date',
        'time',
        'animal_tag_no',
        'referred_by',
        'farmer_name',
        'contact_no',
        'animal',
        'age',
        'gender',
        'temperature',
        'sample',
        'pregnancy',
        'pregnancy_month',
        'deworming',
        'status',
        'image',
        'finding',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            // Set current date and time
            $model->date = now()->format('Y-m-d');
            $model->time = now()->format('H:i:s');
            
            // Set patient_no as the next auto-increment ID
            $model->patient_no = \DB::table('receipts')->max('id') + 1;
        });
    }
}
