<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupplierLedger extends Model
{
    use HasFactory;

    protected $fillable = [
        'supplier_id',
        'company_id',
        'products',         // e.g. "product1 30, product2 50"
        'total_bill',
        'paid_amount',
        'stock_date',
        'due_amount',
        'payment_date',
        'image',
    ];


    // Relationship: each ledger belongs to one supplier
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    // Relationship: each ledger belongs to one company
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
     public function ledgerItems()
    {
        return $this->hasMany(LedgerItem::class, 'ledger_id');
    }
     public function ledgerAdjustments()
{
    return $this->hasMany(ledgerAdjustments::class, 'ledger_id');
}
}
