<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type');
            $table->string('salt')->nullable();
            $table->string('company')->nullable();
            $table->json('categories'); // Store categories as JSON
            $table->string('batch_number');
            $table->integer('quantity');
            $table->date('expiry_date');
            $table->integer('expiry_alert')->default(30);
            $table->integer('low_stock_alert')->default(10);
            $table->string('purchase_from')->nullable();
            $table->decimal('retail_price', 10, 2)->nullable();
            $table->decimal('purchase_price', 10, 2)->nullable();
            $table->decimal('local_price', 10, 2)->nullable();
            $table->decimal('doctor_price', 10, 2)->nullable();
            $table->string('unit_type')->default('packet');
            $table->integer('pieces_per_packet')->nullable();
            $table->decimal('price_per_piece', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
