<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReceiptsTable extends Migration
{
    public function up()
    {
        Schema::create('receipts', function (Blueprint $table) {
            $table->id(); 
             $table->integer('patient_no')->nullable();
            $table->date('date')->default(DB::raw('CURRENT_DATE'));
            $table->time('time')->default(DB::raw('CURRENT_TIME'));
            $table->string('animal_tag_no');
            $table->string('referred_by')->nullable();
            $table->string('farmer_name');
            $table->string('contact_no');
            $table->string('animal');
            $table->integer('age')->nullable();
            $table->string('gender');
            $table->float('temperature')->nullable();
            $table->string('sample')->nullable();
            $table->string('pregnancy')->default('No');
            $table->integer('pregnancy_month')->nullable();
            $table->string('deworming')->default('No');
            $table->string('status')->default('Pending');
            $table->string('image')->nullable();
            $table->text('finding')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('receipts');
    }
}
