<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ledger_items', function (Blueprint $table) {
            $table->id();
            
            // Changed to reference supplier_ledgers table
            $table->foreignId('ledger_id')
                  ->constrained('supplier_ledgers')
                  ->onDelete('cascade');
                  
            $table->string('stock');
            $table->decimal('total_amount', 10, 2);
            $table->decimal('paid_amount', 10, 2)->default(0);
            $table->decimal('due_amount', 10, 2)->virtualAs('total_amount - paid_amount');
            $table->date('ledger_date');
            $table->date('payment_date')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('ledger_id');
            $table->index('ledger_date');
            $table->index('payment_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ledger_items');
    }
};