<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('receipt_print', function (Blueprint $table) {
            $table->string('background_image')->nullable()->after('footer');
            $table->string('border1_color')->default('#000000')->after('background_image');
            $table->integer('border1_width')->default(1)->after('border1_color');
            $table->string('border2_color')->default('#000000')->after('border1_width');
            $table->integer('border2_width')->default(1)->after('border2_color');
            $table->string('footer_background_color')->default('#f3f4f6')->after('border2_width');
            $table->string('footer_text_color')->default('#000000')->after('footer_background_color');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('receipt_print', function (Blueprint $table) {
            $table->dropColumn([
                'background_image',
                'border1_color',
                'border1_width',
                'border2_color',
                'border2_width',
                'footer_background_color',
                'footer_text_color'
            ]);
        });
    }
};