@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto py-6">
    <h1 class="text-2xl font-bold mb-6">Buy Outside Product</h1>

    <form action="{{ route('storeOutside') }}" method="POST">
        @csrf

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <h2 class="text-lg font-semibold mb-2">Product Information</h2>
            
            <!-- Product Details -->
            <input type="hidden" name="products[0][id]" value="{{ $product->id }}">
            <input type="hidden" name="products[0][sale_type]" value="outside">
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <p><strong>Name:</strong> {{ $product->name }}</p>
                    <p><strong>Company:</strong> {{ $product->company }}</p>
                    <p><strong>Type:</strong> {{ $product->type }}</p>
                </div>
                <div>
                    <p><strong>Salt:</strong> {{ $product->salt }}</p>
                    <p><strong>Retail Price:</strong> {{ $product->retail_price }}</p>
                </div>
            </div>

            <!-- Sold As Selection -->
            <div class="mb-4">
                <label class="block font-medium mb-1">Sold As:</label>
                <select name="products[0][sold_as]" id="sold-as" class="border p-2 rounded w-full">
                    <option value="packet">Packet</option>
                    <option value="loss_pack">Loss Pack</option>
                </select>
            </div>

            <!-- Quantity Input -->
            <div class="mb-4">
                <label class="block font-medium mb-1">Quantity:</label>
                <input 
                    type="number" 
                    name="products[0][qty]" 
                    id="quantity" 
                    class="border p-2 rounded w-full" 
                    min="1" 
                    value="1"
                    required
                >
            </div>

          

            <!-- Price Type Selection -->
            <div class="mb-4">
                <label class="block font-medium mb-1">Price Type:</label>
                <select name="products[0][price_type]" id="price-type" class="border p-2 rounded w-full">
                    <option value="retail">Retail Price ({{ $product->retail_price }})</option>
                    <option value="doctor">Doctor Price ({{ $product->doctor_price }})</option>
                    <option value="local">Local Price ({{ $product->local_price }})</option>
                    <option value="purchase">Purchase Price ({{ $product->purchase_price }})</option>
                </select>
            </div>

            <!-- Custom Price Input -->
            <div class="mb-4">
                <label class="block font-medium mb-1">Price:</label>
                <input 
                    type="number" 
                    name="products[0][price]" 
                    id="price" 
                    class="border p-2 rounded w-full" 
                    step="0.01"
                    min="0"
                    value="{{ $product->retail_price }}"
                    required
                >
            </div>

            <!-- Total Price (Calculated) -->
            <div class="mb-4">
                <label class="block font-medium mb-1">Total Price:</label>
                <input 
                    type="text" 
                    name="products[0][total]" 
                    id="total-price" 
                    class="border p-2 rounded w-full bg-gray-100" 
                    readonly
                >
            </div>
        </div>

        <!-- Payment Type -->
        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium mb-1">Payment Type:</label>
            <select name="payment_type" id="payment-type" class="border p-2 rounded w-full">
                <option value="cash">Cash</option>
                <option value="credit">Credit</option>
            </select>
        </div>
        <div  class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium mb-1">Remarks:</label>
            <input 
                type="text" 
                name="remarks" 
                class="border p-2 rounded w-full" 
                placeholder="Enter 
                Remarks if any"
            >
        </div>

        <!-- Cash Customer Info (Visible by default) -->
        <div id="cash-info" class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium mb-1">Customer Name:</label>
            <input 
                type="text" 
                name="cash_customer_name" 
                class="border p-2 rounded w-full" 
                placeholder="Enter customer name"
            >
        </div>

        <!-- Credit Customer Info (Hidden by default) -->
        <div id="credit-info" class="border p-4 rounded mb-6 bg-white shadow-sm hidden">
            <div class="mb-4">
                <label class="block font-medium mb-1">Search Customer:</label>
                <input 
                    type="text" 
                    id="customer-search" 
                    class="border p-2 rounded w-full" 
                    placeholder="Enter customer name or phone"
                >
                <input type="hidden" name="customer_id" id="customer-id">
            </div>

            <!-- Customer Suggestions -->
            <div id="customer-suggestions" class="mb-4 hidden"></div>

            <!-- New Customer Fields -->
            <div id="new-customer-fields" class="hidden">
                <div class="mb-4">
                    <label class="block font-medium mb-1">Customer Name:</label>
                    <input 
                        type="text" 
                        name="new_customer_name" 
                        class="border p-2 rounded w-full" 
                        placeholder="Enter customer name"
                    >
                </div>
                <div class="mb-4">
                    <label class="block font-medium mb-1">Customer Phone:</label>
                    <input 
                        type="text" 
                        name="new_customer_phone" 
                        class="border p-2 rounded w-full" 
                        placeholder="Enter customer phone"
                    >
                </div>
                <div class="mb-4">
                    <label class="block font-medium mb-1">Customer Address:</label>
                    <textarea 
                        name="new_customer_address" 
                        class="border p-2 rounded w-full" 
                        placeholder="Enter customer address"
                    ></textarea>
                </div>
            </div>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Submit Bill
        </button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get DOM elements
    const soldAsSelect = document.getElementById('sold-as');
    const quantityInput = document.getElementById('quantity');
    const priceInput = document.getElementById('price');
    const priceTypeSelect = document.getElementById('price-type');
    const totalPriceInput = document.getElementById('total-price');
    const lossPackQuantityContainer = document.getElementById('loss-pack-quantity-container');
    const lossPackQuantityInput = document.getElementById('loss-pack-quantity');
    const paymentTypeSelect = document.getElementById('payment-type');
    const cashInfo = document.getElementById('cash-info');
    const creditInfo = document.getElementById('credit-info');
    const customerSearch = document.getElementById('customer-search');
    const customerSuggestions = document.getElementById('customer-suggestions');
    const newCustomerFields = document.getElementById('new-customer-fields');

    // Initialize total price
    calculateTotal();

    // Event listeners
    soldAsSelect.addEventListener('change', handleSoldAsChange);
    quantityInput.addEventListener('input', calculateTotal);
    priceInput.addEventListener('input', calculateTotal);
    priceTypeSelect.addEventListener('change', updatePrice);
    paymentTypeSelect.addEventListener('change', handlePaymentTypeChange);
    customerSearch.addEventListener('input', searchCustomers);

    // Handle sold as selection change
    function handleSoldAsChange() {
        if (soldAsSelect.value === 'loss_pack') {
            lossPackQuantityContainer.classList.remove('hidden');
            lossPackQuantityInput.setAttribute('required', '');
        } else {
            lossPackQuantityContainer.classList.add('hidden');
            lossPackQuantityInput.removeAttribute('required');
        }
        calculateTotal();
    }

    // Update price based on price type selection
    function updatePrice() {
        const priceType = priceTypeSelect.value;
        let price = 0;

        switch(priceType) {
            case 'retail':
                price = {{ $product->retail_price }};
                break;
            case 'doctor':
                price = {{ $product->doctor_price }};
                break;
            case 'local':
                price = {{ $product->local_price }};
                break;
            case 'purchase':
                price = {{ $product->purchase_price }};
                break;
        }

        priceInput.value = price;
        calculateTotal();
    }

    // Calculate total price
    function calculateTotal() {
        const quantity = parseFloat(quantityInput.value) || 0;
        const price = parseFloat(priceInput.value) || 0;
        const total = quantity * price;
        
        totalPriceInput.value = total.toFixed(2);
    }

    // Handle payment type change
    function handlePaymentTypeChange() {
        if (paymentTypeSelect.value === 'credit') {
            cashInfo.classList.add('hidden');
            creditInfo.classList.remove('hidden');
        } else {
            cashInfo.classList.remove('hidden');
            creditInfo.classList.add('hidden');
        }
    }

    // Search customers
    function searchCustomers() {
        const query = customerSearch.value.trim();
        
        if (query.length >= 2) {
            fetch(`/customers/search?q=${query}`)
                .then(response => response.json())
                .then(data => {
                    customerSuggestions.innerHTML = '';
                    
                    if (data.length > 0) {
                        customerSuggestions.classList.remove('hidden');
                        newCustomerFields.classList.add('hidden');
                        
                        data.forEach(customer => {
                            const div = document.createElement('div');
                            div.className = 'p-2 border-b cursor-pointer hover:bg-gray-100';
                            div.textContent = `${customer.name} - ${customer.phone}`;
                            div.addEventListener('click', () => {
                                document.getElementById('customer-id').value = customer.id;
                                customerSearch.value = `${customer.name} (${customer.phone})`;
                                customerSuggestions.classList.add('hidden');
                            });
                            customerSuggestions.appendChild(div);
                        });
                    } else {
                        customerSuggestions.classList.add('hidden');
                        newCustomerFields.classList.remove('hidden');
                    }
                });
        } else {
            customerSuggestions.classList.add('hidden');
            newCustomerFields.classList.add('hidden');
        }
    }
});
</script>
@endsection 