@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-2xl font-semibold mb-4">Cash Out Report</h1>

    <!-- Date Filter Form -->
    <div class="bg-white p-4 rounded-lg shadow-md mb-6">
        <form method="GET" action="{{ route('credit.report') }}" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="w-full md:w-auto">
                <label for="start_date" class="block text-sm font-medium text-gray-700">From Date</label>
                <input type="date" id="start_date" name="start_date" 
                       value="{{ request('start_date') }}" 
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            
            <div class="w-full md:w-auto">
                <label for="end_date" class="block text-sm font-medium text-gray-700">To Date</label>
                <input type="date" id="end_date" name="end_date" 
                       value="{{ request('end_date') }}" 
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            
            <button type="submit" 
                    class="w-full md:w-auto px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                Filter
            </button>
            
            @if(request()->has('start_date'))
            <a href="{{ route('credit.report') }}" 
               class="w-full md:w-auto px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2">
                Clear Filters
            </a>
            @endif
        </form>
    </div>

    <!-- Tabs Navigation -->
    <div class="mb-4 border-b border-gray-200">
        <ul class="flex flex-wrap -mb-px" id="cashOutTabs" role="tablist">
            <li class="mr-2" role="presentation">
                <button class="inline-block p-4 border-b-2 rounded-t-lg" 
                        id="suppliers-tab" data-tabs-target="#suppliers" type="button" role="tab" 
                        aria-controls="suppliers" aria-selected="true">
                    Supplier Payments
                </button>
            </li>
            <li class="mr-2" role="presentation">
                <button class="inline-block p-4 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300" 
                        id="expenses-tab" data-tabs-target="#expenses" type="button" role="tab" 
                        aria-controls="expenses" aria-selected="false">
                    Customer Credit
                </button>
            </li>
        </ul>
    </div>

    <!-- Tabs Content -->
    <div id="cashOutTabsContent">
        <!-- Supplier Payments Tab -->
        <div class="hidden p-4 rounded-lg bg-white" id="suppliers" role="tabpanel" aria-labelledby="suppliers-tab">
            @if($supplierPayments->isNotEmpty())
                @php
                    $paidTotal = $supplierPayments->sum('paid_amount');
                    $dueTotal = $supplierPayments->sum('due_amount');
                @endphp
                
                <div class="bg-white rounded-lg shadow overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Supplier</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Company</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Bill</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($supplierPayments as $payment)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $payment['supplier_name'] }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $payment['company_name'] }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $payment['product_name'] }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($payment['total_bill'], 2) }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($payment['paid_amount'], 2) }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($payment['due_amount'], 2) }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ Carbon\Carbon::parse($payment['stock_date'])->format('Y-m-d') }}</td>
                                </tr>
                            @endforeach
                            <tr class="bg-gray-50 font-semibold">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900" colspan="4">Total Paid Payments</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($paidTotal, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                            </tr>
                            <tr class="bg-gray-50 font-semibold">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900" colspan="5">Total Due Payments</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($dueTotal, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @else
                <div class="p-6 rounded-lg shadow-md text-center">
                    <p class="text-gray-600">No supplier payments recorded for the selected date range.</p>
                </div>
            @endif
        </div>

        <!-- Extra Expenses Tab -->
        <div class="hidden p-4 rounded-lg bg-white" id="expenses" role="tabpanel" aria-labelledby="expenses-tab">
            @if($creditDetail->isNotEmpty())
                @php
                    $creditTotal = $creditDetail->sum('due_amount');
                    $creditPaid = $creditDetail->sum('is_paid');
                @endphp
                
                <div class="bg-white rounded-lg shadow overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer Name</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phone</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                           
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($creditDetail as $credit)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $credit['customer_name'] }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $credit['phone'] }}</td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"> Rs. {{ number_format($credit['due_amount'], 2) }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"> Rs. {{ number_format($credit['is_paid'], 2) }}</td>
                                    
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ Carbon\Carbon::parse($credit['date'])->format('Y-m-d') }}</td>
                                </tr>
                            @endforeach
                            <tr class="bg-gray-50 font-semibold">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900" colspan="2">Total Credit Amount</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($creditTotal, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                            </tr>
                            <tr class="bg-gray-50 font-semibold">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900" colspan="3">Paid Credit Amount</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($creditPaid, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @else
                <div class="p-6 rounded-lg shadow-md text-center">
                    <p class="text-gray-600">No extra expenses recorded for the selected date range.</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Tabbed Interface Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const tabs = document.querySelectorAll('[data-tabs-target]');
    const tabContents = document.querySelectorAll('[role="tabpanel"]');

    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            const target = document.querySelector(tab.dataset.tabsTarget);
            
            // Hide all tab contents
            tabContents.forEach(content => {
                content.classList.add('hidden');
            });
            
            // Show the selected tab content
            target.classList.remove('hidden');
            
            // Update active tab styling
            tabs.forEach(t => {
                t.classList.remove('border-blue-500', 'text-blue-600');
                t.classList.add('border-transparent');
            });
            
            tab.classList.add('border-blue-500', 'text-blue-600');
            tab.classList.remove('border-transparent');
        });
    });

    // Activate the first tab by default
    document.querySelector('[data-tabs-target="#suppliers"]').click();
});
</script>
@endsection