@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">

    <div id="receipt">
        @foreach (['Department Copy', 'Customer Copy'] as $index => $copyType)
        <div class="copy-page mb-12 {{ $index === 1 ? 'relative pt-20' : '' }}">
            
            @if($index === 1)
            <!-- Separation Line -->
            <div class="absolute top-0 left-0 w-full flex items-center justify-center print:block">
                <div class="w-full border-t-2 border-dashed border-gray-500 print:mt-10 mb-10"></div>
                <div class="absolute -top-3 left-1/2 transform -translate-x-1/2 bg-white px-2 text-sm font-semibold text-gray-500">
                    Tear Here
                </div>
            </div>
            @endif

            <!-- Header Section -->
           <div id="storeHeader{{ $index }}" class="text-center mb-6">
    @if($printSetting->logo_path)
        <img id="headerLogo{{ $index }}" src="{{ asset('storage/' . $printSetting->logo_path) }}" alt="Store Logo" class="mx-auto mb-4" style="max-width: 150px; height: auto;">
    @endif
    <h1 id="headerTitle{{ $index }}" class="text-3xl font-bold">{{ $printSetting->title }}</h1>
    <p id="headerAddress{{ $index }}" class="text-lg text-gray-800">{{ $printSetting->address }}</p>
    <p id="headerPhone{{ $index }}" class="text-lg text-gray-800 font-semibold">Phone: {{ $printSetting->phone }}</p>
    <p id="copyType{{ $index }}" class="mt-2 text-xl font-bold text-blue-700 uppercase">{{ $copyType }}</p>
</div>


            <!-- Bill Info -->
            <div class="border-t border-b py-4 mb-4 text-lg">
                @php
                    $details = [
                        'Bill ID' => $bill->id,
                        'Customer Name' => $bill->customer_name ?? 'N/A',
                        'Date' => $bill->date,
                        'Payment Type' => $bill->payment,
                        'Total Amount' => 'Rs. ' . $bill->total_amount,
                        'Remarks' => $bill->remarks ?? 'N/A',
                        'Price Type' => $bill->price_type ?? 'N/A',
                    ];
                @endphp
                @foreach($details as $label => $value)
                    <div class="flex justify-between mb-2">
                        <div class="font-bold">{{ $label }}:</div>
                        <div class="text-right">{{ $value }}</div>
                    </div>
                @endforeach
            </div>

            <!-- Items Table -->
            <div class="mb-6">
                <h2 class="text-xl font-semibold mb-2">Bill Items</h2>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-lg text-left border">
                        <thead class="bg-gray-100 font-semibold">
                            <tr>
                                <th class="border px-4 py-2">#</th>
                                <th class="border px-4 py-2">Product</th>
                                <th class="border px-4 py-2">Qty</th>
                                <th class="border px-4 py-2">Unit Price</th>
                                <th class="border px-4 py-2">Total</th>
                            </tr>
                        </thead>
                       <tbody>
    @forelse ($bill->outsideItems ?? [] as $i => $item)
    <tr>
        <td class="border px-4 py-2">{{ $i + 1 }}</td>
        <td class="border px-4 py-2">
            {{ $item->product_name }} {{-- Changed from product->name to just name --}}
        </td>
        <td class="border px-4 py-2">{{ $item->qty }}</td>
        <td class="border px-4 py-2">Rs. {{ $item->price }}</td>
        <td class="border px-4 py-2">Rs. {{ $item->qty * $item->price }}</td>
    </tr>
    @empty
    <tr>
        <td colspan="5" class="border px-4 py-2 text-center">No items found</td>
    </tr>
    @endforelse
</tbody>
                    </table>
                </div>
            </div>

            <!-- Store Footer Note -->
            <div class="mt-4 text-base text-gray-800">
                <p><strong>Note:</strong> {{ $printSetting->footer_note }}</p>
            </div>

            <!-- Goodbye Message -->
            <div class="mt-6 text-center font-semibold text-lg">
                <p>{{ $printSetting->goodbye_message }}</p>
            </div>

            <!-- Software Credit -->
            <div class="mt-10 pt-4 border-t text-center text-sm text-gray-600 print:text-black">
                <p class="mb-1">Software developed by <span class="font-semibold text-gray-800">Next Steps Sols Pvt. Ltd.</span></p>
                <p class="mb-1">🌐 <a href="https://www.nextstepsols.com" class="text-blue-600 hover:underline" target="_blank">www.nextstepsols.com</a></p>
                <p>📞 Cell: 0332-0679987</p>
            </div>
        </div>
        @endforeach
    </div>

    <!-- Action Buttons -->
    <div class="mt-6 flex justify-center space-x-4 print:hidden">
        <button onclick="setbillPrintMode(true)" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
            Detailed Print
        </button>
        <button onclick="setbillPrintMode(false)" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded">
            Simple Print
        </button>
        <button onclick="handlePrint({{ $bill->id }}, '{{ $bill->status }}')" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
            Print
        </button>
       
    </div>
<script>

function setbillPrintMode(detailed) {
    for (let i = 0; i < 2; i++) {
        const logo = document.getElementById(`headerLogo${i}`);
        const title = document.getElementById(`headerTitle${i}`);
        const address = document.getElementById(`headerAddress${i}`);
        const phone = document.getElementById(`headerPhone${i}`);
        const copyType = document.getElementById(`copyType${i}`);
        const goodbye = document.getElementById(`goodbyeMessage${i}`);
        const software = document.getElementById(`softwareCredit${i}`);
        const header = document.getElementById(`storeHeader${i}`);

        if (detailed) {
            logo && (logo.style.display = 'block');
            title && (title.style.display = 'block');
            address && (address.style.display = 'block');
            phone && (phone.style.display = 'block');
            copyType && (copyType.style.display = 'block');
            // goodbye && (goodbye.style.display = 'block');
            // software && (software.style.display = 'block');
            // header && (header.style.justifyContent = 'center');
        } else {
            logo && (logo.style.display = 'none');
            title && (title.style.display = 'none');
            address && (address.style.display = 'none');
            phone && (phone.style.display = 'none');
            copyType && (copyType.style.display = 'block');
            // goodbye && (goodbye.style.display = 'block');
            // software && (software.style.display = 'block');
             header && (header.style.justifyContent = 'center');
        }
    }
}




</script>
</div>
@endsection
