@extends('layouts.app')

@section('content')
<div class="flex justify-center mt-10">
    <div class="w-full max-w-2xl bg-white rounded-lg shadow-lg p-8">
        <h2 class="text-3xl font-bold text-gray-800 mb-6 text-center">Add New Company</h2>

        @if (session('success'))
            <div class="mb-4 p-4 bg-green-100 text-green-800 rounded">
                {{ session('success') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="mb-4 p-4 bg-red-100 text-red-800 rounded">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('company.create') }}" class="space-y-6">
            @csrf

            <div>
                <label for="company_name" class="block text-sm font-medium text-gray-700"> Company Name</label>
                <input type="text" name="company_name" id="company_name" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
           </select>
            </div>

            <div>
                <label for="address" class="block text-sm font-medium text-gray-700">Address</label>
                <input type="text" name="address" id="address" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            {{-- Phone --}}
            <div>
                <label for="company_phone" class="block text-sm font-medium text-gray-700">Phone</label>
                <input type="text" name="company_phone" id="company_phone" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            <div class="text-center">
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                    Add Company
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
