@extends('layouts.app')

@section('content')
<div class="flex justify-center mt-10">
    <div class="w-full max-w-2xl bg-white rounded-lg shadow-lg p-8">
        <h2 class="text-3xl font-bold text-gray-800 mb-6 text-center">Create New Demand</h2>

        @if (session('success'))
            <div class="mb-4 p-4 bg-green-100 text-green-800 rounded">
                {{ session('success') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="mb-4 p-4 bg-red-100 text-red-800 rounded">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('demand.create') }}" class="space-y-6">
            @csrf

            {{-- Company Selector --}}
            <div>
                <label for="company_name" class="block text-sm font-medium text-gray-700">Company Name</label>
               <input type="text" name="company_name" id="company_name" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
           
            </div>

            {{-- Supplier Selector --}}
            <div>
                <label for="supplier_name" class="block text-sm font-medium text-gray-700">Supplier Name</label>
                <input type="text" name="supplier_name" id="supplier_name" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
           
            </div>

            {{-- Product Name --}}
            <div>
                <label for="product_name" class="block text-sm font-medium text-gray-700">Product Name</label>
                <input type="text" name="product_name" id="product_name" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            {{-- Quantity --}}
            <div>
                <label for="quantity" class="block text-sm font-medium text-gray-700">Quantity</label>
                <input type="number" name="quantity" id="quantity" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            {{-- Reminder DateTime --}}
            <div>
                <label for="reminder" class="block text-sm font-medium text-gray-700">Reminder (Date & Time)</label>
                <input type="datetime-local" name="reminder" id="reminder" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            <div class="text-center">
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                    Submit Demand
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
