@extends('layouts.app')

@section('content')
    <div class="max-w-4xl mx-auto p-6 bg-white shadow rounded">
        <h1 class="text-3xl font-bold mb-6">Extra Expenses</h1>

        <form action="{{ route('extra_expenses.index') }}" method="GET" class="mb-4 grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label for="start_date" class="text-sm font-semibold">Start Date</label>
                <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="w-full p-2 border border-gray-300 rounded">
            </div>
            <div>
                <label for="end_date" class="text-sm font-semibold">End Date</label>
                <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="w-full p-2 border border-gray-300 rounded">
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">Filter</button>
            </div>
        </form>

        @if($expenses->count())
            <h2 class="text-xl font-semibold mb-4">
                @if($start_date && $end_date)
                    Showing expenses from {{ $start_date }} to {{ $end_date }}
                @else
                    Showing all expenses
                @endif
            </h2>

           <div class="bg-white rounded-lg shadow overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                    <tr class="bg-gray-100">
                        <th class="border px-4 py-2">Date</th>
                        <th class="border px-4 py-2">Amount</th>
                        <th class="border px-4 py-2">Description</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($expenses as $expense)
                        <tr>
                            <td class="border px-4 py-2">{{ $expense->expense_date }}</td>
                            <td class="border px-4 py-2">Rs. {{ $expense->amount }}</td>
                            <td class="border px-4 py-2">{{ $expense->description ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
</div>
            <div>
            @php
    $ids = $expenses->pluck('id')->toArray();
    $idParam = implode(',', $ids);
@endphp

<a href="{{ route('extra_expenses.print', ['ids' => $idParam, 'start_date' => $start_date, 'end_date' => $end_date]) }}"
   class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
    Print Report
</a>

            </div>
        @else
            <p class="text-gray-600">No expenses found.</p>
        @endif
    </div>
@endsection
