@extends('layouts.app')

@section('content')
<div class="mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">

    <div id="receipt">

        <!-- Store Header -->
        <div class="text-center mb-6">
            <img src="{{ asset('images/logo.png') }}" alt="Faisal Veterinary Store Logo" class="mx-auto mb-4" style="max-width: 150px;">
            <h1 class="text-3xl font-bold">Faisal Veterinary Store</h1>
            <p class="text-sm text-gray-700">Liaqat Road Near Tasty Hotel, Mian Channu</p>
            <p class="text-sm text-gray-700">Phone: 0333-4114499</p>
        </div>

        <!-- Report Heading -->
        <div class="text-center mb-4">
            <h2 class="text-2xl font-semibold">Extra Expenses Report</h2>
            @if($start_date && $end_date)
                <p class="text-sm text-gray-600 mt-1">
                    Showing records from <strong>{{ $start_date }}</strong> to <strong>{{ $end_date }}</strong>
                </p>
            @endif
        </div>

        <!-- Table -->
        @if($expenses->count())
            <div class="overflow-x-auto">
                <table class="min-w-full table-auto border border-gray-300">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-4 py-2 border">Date</th>
                            <th class="px-4 py-2 border">Amount (Rs.)</th>
                            <th class="px-4 py-2 border">Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($expenses as $expense)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-2 border">{{ $expense->expense_date }}</td>
                                <td class="px-4 py-2 border">Rs. {{ $expense->amount }}</td>
                                <td class="px-4 py-2 border">{{ $expense->description ?? 'N/A' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <p class="text-center text-gray-600 mt-4">No expense records found for the selected range.</p>
        @endif

    </div>

    <!-- Print Button -->
    <div class="mt-6 flex justify-center print:hidden">
        <button onclick="window.print()" class="bg-green-500 hover:bg-green-600 text-white px-6 py-2 rounded shadow">
            Print
        </button>
    </div>

</div>
@endsection
