@extends('layouts.app')

@section('content')
<div class="max-w-5xl mx-auto p-6 bg-white rounded shadow mt-10">
    <h2 class="text-2xl font-bold mb-6">Add New Product</h2>

    <form action="{{ route('product.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <!-- Basic Product Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Product Name</label>
                <input type="text" name="name" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Product Type</label>
                <input type="text" name="type" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Salt</label>
                <input type="text" name="salt" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Product Company</label>
                <input type="text" name="company" class="w-full border px-3 py-2 rounded">
            </div>

            <!-- Multi-select for Category -->
            <div class="md:col-span-2">
                <label class="font-semibold">Product Category</label>
                <select name="categories[]" class="w-full border px-3 py-2 rounded" multiple>
                    <option value="injection">Injection</option>
                    <option value="syrup">Syrup</option>
                    <option value="tablet">Tablet</option>
                    <option value="powder">Powder</option>
                    <option value="drip">Drip</option>
                    <option value="instrument">Instrument</option>
                    <option value="other">Other</option>
                </select>
                <p class="text-sm text-gray-500 mt-1">Hold Ctrl to select multiple.</p>
            </div>
        </div>

        <hr class="my-6">

        <!-- Batch Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Batch Number</label>
                <input type="text" name="batch_number" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Quantity</label>
                <input type="number" name="quantity" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Date</label>
                <input type="date" name="expiry_date" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Alert (Days Before)</label>
                <input type="number" name="expiry_alert" class="w-full border px-3 py-2 rounded" value="30">
            </div>
            <div>
                <label class="font-semibold">Low Stock Alert</label>
                <input type="number" name="low_stock_alert" class="w-full border px-3 py-2 rounded" value="10">
            </div>
            <div>
                <label class="font-semibold">Purchase From</label>
                <input type="text" name="purchase_from" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Pricing -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Retail Price (Full Packet)</label>
                <input type="number" step="0.01" name="retail_price" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Purchase Price</label>
                <input type="number" step="0.01" name="purchase_price" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Local Customer Sale Price</label>
                <input type="number" step="0.01" name="local_price" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Doctor Sale Price</label>
                <input type="number" step="0.01" name="doctor_price" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Sold As: Packet or Loss Pack -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Sold As</label>
                <select name="unit_type" class="w-full border px-3 py-2 rounded" id="unitTypeSelect">
                    <option value="packet">Full Packet</option>
                    <option value="loss_pack">Loss Pack (e.g., per piece/ml)</option>
                </select>
            </div>
        </div>

        <!-- Loss Pack Specific Fields -->
        <div id="lossPackFields" class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4 hidden">
            <div>
                <label class="font-semibold">Quantity in One Packet (e.g., tablets/ml)</label>
                <input type="number" name="pieces_per_packet" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Price Per Unit (e.g., per tablet/ml)</label>
                <input type="number" step="0.01" name="price_per_piece" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <!-- Image Upload -->
     <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-6">
    <div>
        <label class="font-semibold">Product Image</label>

        <!-- Action buttons -->
        <div class="flex gap-2 mb-2">
            <button type="button" onclick="document.getElementById('fileInput').click()" class="bg-blue-500 text-white px-3 py-1 rounded">
                📁 Choose
            </button>
            <button type="button" onclick="openCamera()" class="bg-green-500 text-white px-3 py-1 rounded">
                📸 Capture
            </button>
        </div>

        <!-- Actual file input (used by both methods) -->
        <input type="file" id="fileInput" name="image" accept="image/*"
            class="w-full border px-3 py-2 rounded hidden"
            onchange="previewImage(event)" />

        <!-- File input display -->
        <div class="border rounded p-2 bg-gray-50 text-sm text-gray-600 mb-2">
            Upload new image (JPG, PNG, JPEG, max 2MB)
        </div>

        <!-- Camera Selection Dropdown -->
        <div id="cameraSelection" class="hidden mt-2">
            <label class="block mb-1 font-semibold">Select Camera:</label>
            <select id="cameraSelect" onchange="onCameraSelected()" class="border px-2 py-1 rounded text-sm w-full">
            </select>
        </div>

        <!-- Hidden canvas for camera capture -->
        <div id="cameraContainer" class="mt-3 hidden">
            <video id="video" autoplay playsinline class="w-full rounded border"></video>
            <div class="mt-2 flex gap-2">
                <button type="button" onclick="captureImage()" class="bg-red-500 text-white px-3 py-1 rounded">
                    📷 Take Picture
                </button>
                <button type="button" onclick="closeCamera()" class="bg-gray-500 text-white px-3 py-1 rounded">
                    ✖ Close Camera
                </button>
            </div>
        </div>
    </div>

    <div>
        <label class="font-semibold">Preview</label>
        <img id="imagePreview" src="#" alt="Image Preview"
            class="w-32 h-32 object-cover border rounded mt-2 hidden">
    </div>
</div>

<canvas id="canvas" class="hidden"></canvas>


        <div class="mt-6">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold px-6 py-2 rounded">
                Add Product
            </button>
        </div>
    </form>
</div>

<!-- JS for conditional display and image preview -->

<script>
let stream;
let videoDevices = [];
let isMobileDevice = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);

// File input preview
function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('imagePreview');

    if (input.files && input.files[0]) {
        const reader = new FileReader();

        reader.onload = function (e) {
            preview.src = e.target.result;
            preview.classList.remove('hidden');
        };

        reader.readAsDataURL(input.files[0]);
    }
}

// Open camera and show live feed
async function openCamera() {
    try {
        // First get permission to access any camera
        const tempStream = await navigator.mediaDevices.getUserMedia({ video: true });
        tempStream.getTracks().forEach(track => track.stop()); // Stop immediately after getting permission
        
        // Now enumerate devices with labels
        const devices = await navigator.mediaDevices.enumerateDevices();
        videoDevices = devices.filter(device => device.kind === 'videoinput');

        if (videoDevices.length === 0) {
            alert("No camera devices found.");
            return;
        }

        // Always show the camera container
        document.getElementById('cameraContainer').classList.remove('hidden');

        // Show camera selection if mobile or multiple cameras
        if (isMobileDevice || videoDevices.length > 1) {
            showCameraSelection(videoDevices);
        } else {
            // For desktop with single camera, start directly
            startStream(videoDevices[0].deviceId);
        }
    } catch (err) {
        alert("Could not access camera: " + err.message);
    }
}

function showCameraSelection(devices) {
    const select = document.getElementById('cameraSelect');
    select.innerHTML = '';

    devices.forEach((device, index) => {
        const option = document.createElement('option');
        option.value = device.deviceId;

        // Try to determine camera type from label
        const label = (device.label || '').toLowerCase();
        if (label.includes('front')) {
            option.text = 'Front Camera';
        } else if (label.includes('back') || label.includes('rear')) {
            option.text = 'Back Camera';
        } else {
            option.text = `Camera ${index + 1}`;
        }

        select.appendChild(option);
    });

    document.getElementById('cameraSelection').classList.remove('hidden');
}

function onCameraSelected() {
    const deviceId = document.getElementById('cameraSelect').value;
    startStream(deviceId);
}

async function startStream(deviceId) {
    // Stop any existing stream
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }

    try {
        const constraints = {
            video: {
                deviceId: { exact: deviceId },
                width: { ideal: 1280 },
                height: { ideal: 720 }
            }
        };

        stream = await navigator.mediaDevices.getUserMedia(constraints);
        const video = document.getElementById('video');
        video.srcObject = stream;
    } catch (err) {
        alert("Could not start selected camera: " + err.message);
    }
}

function captureImage() {
    const video = document.getElementById('video');
    const canvas = document.getElementById('canvas');
    const fileInput = document.getElementById('fileInput');

    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    canvas.getContext('2d').drawImage(video, 0, 0);

    canvas.toBlob(function (blob) {
        const file = new File([blob], "captured.jpg", { type: "image/jpeg" });
        const dataTransfer = new DataTransfer();
        dataTransfer.items.add(file);

        fileInput.files = dataTransfer.files;
        previewImage({ target: fileInput });
    }, "image/jpeg", 0.9); // 0.9 is the quality (90%)

    closeCamera();
}

function closeCamera() {
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
        stream = null;
    }
    
    document.getElementById('cameraContainer').classList.add('hidden');
    document.getElementById('cameraSelection').classList.add('hidden');
    
    const video = document.getElementById('video');
    video.srcObject = null;
}

// Show/hide loss pack fields
document.getElementById('unitTypeSelect').addEventListener('change', function () {
    const value = this.value;
    const lossPackFields = document.getElementById('lossPackFields');

    if (value === 'loss_pack') {
        lossPackFields.classList.remove('hidden');
    } else {
        lossPackFields.classList.add('hidden');
    }
});

// Clean up when the page is unloaded
window.addEventListener('beforeunload', function() {
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }
});
</script>
@endsection
