@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto p-6 bg-white rounded-xl shadow-md mt-10 overflow-x-auto">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold">Low Sale Product Records</h2>
        <a href="#" id="printSelectedLink"
           class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 transition duration-150">
            Print Selected
        </a>
    </div>

    @if (session('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">{{ session('success') }}</div>
    @endif

    @if ($errors->any())
        <div class="mb-4 p-3 bg-red-100 text-red-700 rounded">
            <ul class="list-disc ml-5">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Filter Form --}}
    <form method="GET" action="{{ route('product.lowSales') }}" id="filterForm" class="flex flex-wrap items-end gap-4 mb-6">
        <div>
            <label for="quick_filter" class="block font-medium mb-1">Quick Filter:</label>
            <select name="quick_filter" id="quick_filter" class="border border-gray-300 rounded px-3 py-1">
                <option value="">Select Period</option>
                <option value="7" {{ request('quick_filter') == '7' ? 'selected' : '' }}>Last 7 Days</option>
                <option value="10" {{ request('quick_filter') == '10' ? 'selected' : '' }}>Last 10 Days</option>
                <option value="15" {{ request('quick_filter') == '15' ? 'selected' : '' }}>Last 15 Days</option>
                <option value="30" {{ request('quick_filter') == '30' ? 'selected' : '' }}>Last 30 Days</option>
                <option value="custom" {{ request('quick_filter') == 'custom' ? 'selected' : '' }}>Custom Date</option>
            </select>
        </div>

        <div id="custom_date_container" style="{{ (request('quick_filter') == 'custom' || request('since_date')) ? '' : 'display: none;' }}">
            <label for="since_date" class="block font-medium mb-1">Custom Date:</label>
            <input type="date" name="since_date" id="since_date"
                   class="border border-gray-300 rounded px-3 py-1"
                   value="{{ request('since_date') }}">
        </div>

        <button type="submit"
                class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 transition duration-150">
            Filter Products
        </button>

        @if(request('quick_filter') || request('since_date'))
            <a href="{{ route('product.lowSales') }}"
               class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-700 transition duration-150">
                Reset
            </a>
        @endif
    </form>

    @if($products->count())
        <div class="overflow-x-auto">
            <table class="min-w-full border text-left text-sm">
                <thead class="bg-gray-100 text-gray-700">
                    <tr>
                        <th class="py-2 px-4 border-b">
                            <input type="checkbox" id="selectAll" class="form-checkbox">
                        </th>
                        <th class="py-2 px-4 border-b">Product Name</th>
                        <th class="py-2 px-4 border-b">Categories</th>
                        <th class="py-2 px-4 border-b">Company</th>
                        <th class="py-2 px-4 border-b">Batch No</th>
                        <th class="py-2 px-4 border-b">Expiry Date</th>
                        <th class="py-2 px-4 border-b">Quantity</th>
                        <th class="py-2 px-4 border-b">Unit Type</th>
                        <th class="py-2 px-4 border-b">Purchase Price</th>
                        <th class="py-2 px-4 border-b">Retail Price</th>
                        <th class="py-2 px-4 border-b">Local Price</th>
                        <th class="py-2 px-4 border-b">Doctor Price</th>
                        <th class="py-2 px-4 border-b">Piece Price</th>
                        <th class="py-2 px-4 border-b">Image</th>
                        <th class="py-2 px-4 border-b">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($products as $product)
                        <tr class="border-b">
                            <td class="py-2 px-4">
                                <input type="checkbox" name="selected_products[]" value="{{ $product->id }}" class="form-checkbox product-checkbox">
                            </td>
                            <td class="py-2 px-4">{{ $product->name }}</td>
                            <td class="py-2 px-4">
                                @foreach ($product->categories as $category)
                                    <span class="inline-block bg-gray-200 text-gray-800 text-xs px-2 py-1 rounded mr-1">
                                        {{ $category }}
                                    </span>
                                @endforeach
                            </td>
                            <td class="py-2 px-4">{{ $product->company }}</td>
                            <td class="py-2 px-4">{{ $product->batch_number }}</td>
                            <td class="py-2 px-4">{{ $product->expiry_date }}</td>
                            <td class="py-2 px-4">{{ $product->quantity }}</td>
                            <td class="py-2 px-4">{{ $product->unit_type }}</td>
                            <td class="py-2 px-4">{{ $product->purchase_price }}</td>
                            <td class="py-2 px-4">{{ $product->retail_price }}</td>
                            <td class="py-2 px-4">{{ $product->local_price }}</td>
                            <td class="py-2 px-4">{{ $product->doctor_price }}</td>
                            <td class="py-2 px-4">{{ $product->price_per_piece }}</td>
                            <td class="py-2 px-4">
                                @if ($product->image)
                                    <img src="{{ asset('storage/' . $product->image) }}"
                                         alt="Product Image"
                                         class="w-12 h-12 rounded border border-gray-300 object-cover">
                                @else
                                    <span class="text-gray-400 text-sm">No Image</span>
                                @endif
                            </td>
                            <td class="py-2 px-4 space-x-2">
                                <a href="{{ route('product.edit', $product->id) }}"
                                   class="text-blue-600 hover:underline">Edit</a>
                                <form action="{{ route('product.delete', $product->id) }}"
                                      method="POST" class="inline-block"
                                      onsubmit="return confirm('Are you sure you want to delete this product?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                            class="text-red-600 hover:underline">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <p class="text-gray-600 mt-4">No products found.</p>
    @endif
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const quickFilter = document.getElementById('quick_filter');
    const customDateContainer = document.getElementById('custom_date_container');
    
    if (quickFilter && customDateContainer) {
        quickFilter.addEventListener('change', function() {
            if (this.value === 'custom') {
                customDateContainer.style.display = 'block';
                document.getElementById('since_date').focus();
            } else {
                customDateContainer.style.display = 'none';
                document.getElementById('since_date').value = '';
            }
        });
    }

    const selectAllCheckbox = document.getElementById('selectAll');
    if (selectAllCheckbox) {
        selectAllCheckbox.addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('.product-checkbox');
            checkboxes.forEach(cb => cb.checked = this.checked);
        });
    }

    const printLink = document.getElementById('printSelectedLink');
    printLink.addEventListener('click', function(event) {
        event.preventDefault();

        const selectedProducts = [];
        document.querySelectorAll('.product-checkbox:checked').forEach(checkbox => {
            selectedProducts.push(checkbox.value);
        });

        if (selectedProducts.length === 0) {
            alert('Please select at least one product to print.');
            return;
        }

        const queryParams = new URLSearchParams();
        selectedProducts.forEach(id => queryParams.append('ids[]', id));

        const url = "{{ route('product.printSelected') }}" + '?' + queryParams.toString();
        window.location.href = url;
    });
});
</script>
@endpush
