@extends('layouts.app')

@section('content')
    <div class="container mx-auto p-6">
        <h1 class="text-2xl font-semibold mb-4">Sales Report</h1>

        <!-- Date Filter Form -->
        <div class="bg-white p-4 rounded-lg shadow-md mb-6">
            <form method="GET" action="{{ route('sale') }}" class="flex flex-col md:flex-row gap-4 items-end">
                <div class="w-full md:w-auto">
                    <label for="start_date" class="block text-sm font-medium text-gray-700">From Date</label>
                    <input type="date" id="start_date" name="start_date" 
                           value="{{ request('start_date') }}" 
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                
                <div class="w-full md:w-auto">
                    <label for="end_date" class="block text-sm font-medium text-gray-700">To Date</label>
                    <input type="date" id="end_date" name="end_date" 
                           value="{{ request('end_date') }}" 
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
                
                <button type="submit" 
                        class="w-full md:w-auto px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                    Filter
                </button>
                
                @if(request()->has('start_date'))
                <a href="{{ route('sale') }}" 
                   class="w-full md:w-auto px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2">
                    Clear Filters
                </a>
                @endif
            </form>
        </div>

        @if($sales->isNotEmpty())
            @php
                $grandTotal = $sales->sum('sold_amount');
            @endphp
            
           <div class="bg-white rounded-lg shadow overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product Type</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Sold Quantity</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Sale Date</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($sales as $sale)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $sale['product_name'] }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $sale['product_type'] }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $sale['sold_qty'] }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($sale['sold_amount'], 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $sale['sale_date'] }}</td>
                            </tr>
                        @endforeach
                        <!-- Grand Total Row -->
                        <tr class="bg-gray-50 font-semibold">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900" colspan="3">Grand Total</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. {{ number_format($grandTotal, 2) }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        @else
            <div class="bg-white p-6 rounded-lg shadow-md text-center">
                <p class="text-gray-600">No sales recorded for the selected date range.</p>
            </div>
        @endif
    </div>
@endsection