@extends('layouts.app')

@section('content')
<div class="max-w-3xl mx-auto px-4 py-10">
    <div class="bg-white shadow-xl rounded-2xl p-8">
        <h2 class="text-2xl font-bold mb-6 text-gray-800">Add Supplier Ledger</h2>

        <form method="POST" action="{{ route('ledger.create') }}" enctype="multipart/form-data" class="space-y-6">
            @csrf

            <!-- Supplier -->
            <div>
                <label for="supplier_id" class="block text-sm font-medium text-gray-700">Select Supplier</label>
                <select name="supplier_id" id="supplier_id" required class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @foreach($suppliers as $supplier)
                        <option value="{{ $supplier->id }}">{{ $supplier->supplier_name }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Company -->
            <div>
                <label for="company_id" class="block text-sm font-medium text-gray-700">Select Company</label>
                <select name="company_id" id="company_id" required class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @foreach($companies as $company)
                        <option value="{{ $company->id }}">{{ $company->company_name }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Products -->
            <div>
                <label for="products" class="block text-sm font-medium text-gray-700">Products & Stock</label>
                <textarea name="products" id="products" rows="3" required placeholder="product1 30, product2 50" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"></textarea>
            </div>

            <!-- Bill Details -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="total_amount" class="block text-sm font-medium text-gray-700">Total Amount</label>
                    <input type="number" step="0.01" name="total_amount" id="total_amount" required placeholder="Total Amount" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label for="paid_amount" class="block text-sm font-medium text-gray-700">Paid Amount</label>
                    <input type="number" step="0.01" name="paid_amount" id="paid_amount" required placeholder="Paid Amount" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>

            <!-- Dates -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="ledger_date" class="block text-sm font-medium text-gray-700">Ledger Date</label>
                    <input type="date" name="ledger_date" id="ledger_date" required class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label for="payment_date" class="block text-sm font-medium text-gray-700">Payment Date</label>
                    <input type="date" name="payment_date" id="payment_date" class="mt-1 block w-full border border-gray-300 rounded-lg shadow-sm px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>

            <!-- Image Upload -->
            <div>
                <label for="image" class="block text-sm font-medium text-gray-700">Upload Image (Optional)</label>
                <input type="file" name="image" id="image" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:border file:rounded-lg file:border-gray-300 file:bg-gray-50 hover:file:bg-gray-100">
            </div>

            <!-- Submit Button -->
            <div class="pt-4">
                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition duration-200">
                    Save Ledger
                </button>
            </div>
        </form>
    </div>
</div>
@endsection