<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthenticationController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\BillController;
use App\Http\Controllers\DemandController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\ReceiptController;
use App\Models\Customer;
use Illuminate\Http\Request;
use App\Http\Controllers\ExtraController;

Route::get('extra-expenses/form', [ExtraController::class, 'expenseForm'])->name('expense.form');
Route::get('extra-expenses', [ExtraController::class, 'index'])->name('extra_expenses.index');
Route::post('extra-expenses/store', [ExtraController::class, 'store'])->name('extra_expenses.store');
Route::get('extra-expenses/print', [ExtraController::class, 'printReport'])->name('extra_expenses.print');
Route::get('/', [AdminController::class, 'welcome'])->name('welcome');
Route::get('/dashboard', [AdminController::class, 'view'])->name('dashboard');
Route::get('/loginForm', [AdminController::class, 'loginShow'])->name('login.index');
Route::get('/registerForm', [AdminController::class, 'registerShow'])->name('register.index');
Route::post('/login', [AuthenticationController::class, 'login'])->name('login');
Route::post('/register', [AuthenticationController::class, 'register'])->name('register');
Route::post('/logout', [AuthenticationController::class, 'logout'])->name('logout');
Route::get('/profile', [AdminController::class, 'profile'])->name('profile');
    Route::get('/profile/edit', [AdminController::class, 'edit'])->name('profile.edit');
    Route::put('/profile/update', [AdminController::class, 'update'])->name('profile.update');
    Route::post('/change-password', [AuthenticationController::class, 'changePassword'])->name('profile.change-password');
    Route::get('/products/{filter?}', [ProductController::class, 'index'])->name('product.index');
    Route::get('/addproducts', [ProductController::class, 'productAdd'])->name('product.create');
    Route::post('/products/store', [ProductController::class, 'productStore'])->name('product.store');
    Route::get('/return-product', [ProductController::class, 'return'])->name('return');
    Route::get('/product-return-search', [ProductController::class, 'searchBillItems'])->name('products.searchBillItems');
 
    Route::post('/submit-return', [ProductController::class, 'submitCart'])->name('product.return');
    Route::get('/product/{id}/edit', [ProductController::class, 'edit'])->name('product.edit');
    Route::put('/product/{id}', [ProductController::class, 'update'])->name('product.update');
    Route::delete('/product/{id}/delete', [ProductController::class, 'delete'])->name('product.delete');
    Route::get('/products-sales/{product}', [ProductController::class, 'productSales'])->name('products.sales');
    Route::get('/low-sales', [ProductController::class, 'lowSalesFilter'])->name('product.lowSales');
    Route::get('/lowSales/print', [ProductController::class, 'printSelected'])->name('product.printSelected');
    Route::get('/products_print', [ProductController::class, 'print'])->name('product.print');

    Route::get('sales/today', [ProductController::class, 'todaySales'])->name('sale');
    Route::get('/sales/report', [ProductController::class, 'salesReport'])->name('sales.report');
    Route::get('/cash-out', [SupplierController::class, 'cashOutReport'])->name('cash-out');
    Route::get('/create-bill', [BillController::class, 'index'])->name('makeBill');
Route::get('/search-products', [ProductController::class, 'search'])->name('products.search');
Route::post('/submit-cart', [BillController::class, 'submitCart'])->name('cart.submit');
Route::get('/bill/create', [BillController::class, 'showBillCreate'])->name('bill.create');
Route::post('/bill/store', [BillController::class, 'BillStore'])->name('bill.store');
Route::get('/bill/details', [BillController::class, 'showBill'])->name('bill.details');
Route::get('/Buy-Outside/{id}', [BillController::class, 'buyOutside'])->name('buyOutside');
Route::post('/store-Outside', [BillController::class, 'storeOutside'])->name('storeOutside');
Route::get('/bill/print-outside/{id}', [BillController::class, 'printOutside'])->name('print.outside');


Route::get('/bill/print-view/{id}', [BillController::class, 'printView'])->name('print.view');
Route::get('/bill/pending{id}', [BillController::class, 'makePending'])->name('bill.pending');
Route::post('/bills/{id}/mark-complete', [BillController::class, 'markComplete'])->name('bills.markComplete');
Route::get('/bills/{bill}/edit', [BillController::class, 'edit'])->name('bill.edit');
Route::put('/bills/{bill}', [BillController::class, 'update'])->name('bill.update');
Route::get('/credit-details', [BillController::class, 'showCredit'])->name('credit.show');
Route::get('/credit-search', [BillController::class, 'searchCredit'])->name('credit.search');
Route::post('/credit/store', [BillController::class, 'creditStore'])->name('credit.store');
Route::get('/credit/create', [BillController::class, 'creditCreate'])->name('credit.create');
Route::put('/credit/update/{id}', [BillController::class, 'creditUpdate'])->name('credit.update');
Route::delete('/credit/{id}/delete', [BillController::class, 'creditDelete'])->name('credit.delete');
Route::get('/credit/details/{customer_id}', [BillController::class, 'showCoustomerCredit'])->name('customer.credit');
Route::post('/credit/add-due/{credit}', [BillController::class, 'addDue'])->name('credit.add-due');

Route::get('/credit-report', [SupplierController::class, 'creditReport'])->name('credit.report');
Route::get('/credit-print/{id}', [SupplierController::class, 'creditPrint'])->name('credit.print');
Route::get('/ledger/{id}/details', [SupplierController::class, 'ledgerDetails'])->name('ledger.details');

Route::get('/company/form', [DemandController::class, 'showCompanyForm'])->name('company.form');
Route::post('/company/create', [DemandController::class, 'companyCreate'])->name('company.create');
Route::get('/company/search', [DemandController::class, 'companySearch'])->name('company.search');
Route::get('/company/index', [DemandController::class, 'companyShow'])->name('company.show');
Route::put('/company/update/{id}', [DemandController::class, 'companyUpdate'])->name('company.update');
Route::delete('/company/{id}/delete', [DemandController::class, 'companyDelete'])->name('company.delete');
Route::get('/demand/form', [DemandController::class, 'showdemandForm'])->name('demand.form');
Route::post('/demand/create', [DemandController::class, 'demandCreate'])->name('demand.create');
Route::get('/demand/search', [DemandController::class, 'searchDemand'])->name('demand.search');
Route::get('/demand/index', [DemandController::class, 'demandShow'])->name('demand.show');
Route::put('/demand/update/{id}', [DemandController::class, 'demandUpdate'])->name('demand.update');
Route::delete('/demand/{id}/delete', [DemandController::class, 'demandDelete'])->name('demand.delete');
Route::post('/note/create', [DemandController::class, 'noteStore'])->name('note.create');
Route::get('/note', [DemandController::class, 'noteShow'])->name('note.show');
Route::get('/note-view', [DemandController::class, 'noteView'])->name('note.view');
Route::put('/note/update/{id}', [DemandController::class, 'noteUpdate'])->name('note.update');
Route::delete('/note/{id}/delete', [DemandController::class, 'noteDelete'])->name('note.delete');
Route::get('/suppliers', [SupplierController::class, 'index'])->name('supplier.show');
Route::get('/suppliers/form', [SupplierController::class, 'supplierForm'])->name('supplier.form');
Route::post('/suppliers/create', [SupplierController::class, 'store'])->name('supplier.create');
Route::put('/supplier/update/{id}', [SupplierController::class, 'update'])->name('supplier.update');
Route::delete('/suppliers/{id}', [SupplierController::class, 'destroy'])->name('supplier.delete');
Route::get('/ledger', [SupplierController::class, 'ShowLedger'])->name('ledger.show');
Route::get('/ledger/form', [SupplierController::class, 'ShowLedgerForm'])->name('ledger.form');
Route::post('/ledger/create', [SupplierController::class, 'ledgerStore'])->name('ledger.create');
Route::put('/ledger/update/{id}', [SupplierController::class, 'ledgerUpdate'])->name('ledger.update');
Route::delete('/ledger/{id}', [SupplierController::class, 'ledgerdestroy'])->name('ledger.delete');
Route::get('/profit', [SupplierController::class, 'profitReport'])->name('reports.profit');
Route::get('/receipt', [ReceiptController::class, 'showForm'])->name('receipt.form');
Route::post('/receipt/create', [ReceiptController::class, 'store'])->name('receipt.store');
Route::get('/receipt/pending', [ReceiptController::class, 'index'])->name('receipt.index');
Route::put('/receipt/update/{id}', [ReceiptController::class, 'update'])->name('receipt.update');
Route::delete('/receipt/{id}', [ReceiptController::class, 'destroy'])->name('receipt.destroy');
Route::get('/receipt-print/{id}', [ReceiptController::class, 'printView'])->name('receipt.print');
Route::get('/receipt-completeprint/{id}', [ReceiptController::class, 'CompleteprintView'])->name('receipt.completeprint');
Route::get('/receipt/complete', [ReceiptController::class, 'complete'])->name('receipt.complete');

    Route::get('/print-preview', [AdminController::class, 'preview'])->name('print.preview');
    Route::get('/print-edit', [AdminController::class, 'Printedit'])->name('print.edit');
    Route::put('/print-update', [AdminController::class, 'Printupdate'])->name('print.update');
Route::get('/receipt-print', [AdminController::class, 'receiptprint'])->name('receipt-print.preview');
Route::put('/receipt-print/{id}', [AdminController::class, 'receiptprintupdate'])->name('receipt-print.update');
Route::post('/receipt-print/create', [AdminController::class, 'receiptprintcreate'])->name('receipt-print.create');
Route::middleware('auth')->get('/counter-close-summary', [AdminController::class, 'summary'])->name('counter.close.summary');
Route::post('/demands/add-from-product/{product}', [DemandController::class, 'addFromProduct'])
    ->name('demands.add-from-product');
Route::get('/product/search-starts', [ProductController::class, 'searchStarts'])->name('product.searchStarts');
Route::get('/bill-search-suggestions', [BillController::class, 'liveSearchSuggestions']);
Route::get('/bill/makesearch-starts', [ProductController::class, 'makebillsearchStarts'])->name('bill.searchStarts');
Route::get('/return-bill-search-suggestions', [BillController::class, 'returnliveSearchSuggestions']);

Route::post('/orders/store-outside', [BillController::class, 'OutsideBill'])->name('orders.storeOutside');

Route::get('/outside-bills', [BillController::class, 'showOutsideBills'])->name('outside-bills.index');
Route::post('/system/reset', [AdminController::class, 'resetSystem'])
    ->middleware('auth')
    ->name('system.reset');
    
Route::get('/customers/search', function (Request $request) {
    $query = $request->q;

    $customers = Customer::where('name', 'like', "%{$query}%")
        ->orWhere('phone', 'like', "%{$query}%")
        ->get();

    return response()->json($customers);
});
