

<?php $__env->startSection('content'); ?>
<div class="max-w-sm mx-auto p-4 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">

    <!-- Create Note -->
    <div class="bg-yellow-100 rounded-xl shadow-md p-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">📝 Add a Note</h3>

        <form method="POST" action="<?php echo e(route('note.create')); ?>">
            <?php echo csrf_field(); ?>
            <div class="mb-4">
                <label for="noteTitle" class="block text-sm font-medium text-gray-700">Note Title</label>
                <input type="text" id="noteTitle" name="title" placeholder="e.g. Follow up with supplier"
                    class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:ring focus:ring-yellow-300" required />
            </div>

            <div class="mb-4">
                <label for="noteText" class="block text-sm font-medium text-gray-700">Note</label>
                <textarea id="noteText" name="note" rows="6" placeholder="Type your note here..."
                    class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:ring focus:ring-yellow-300 resize-none urdu-font" required></textarea>
            </div>

            <div class="flex justify-between mt-2">
                <button type="button" onclick="printNote()" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-700">
                    🖨️ Print Only
                </button>

                <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">
                    💾 Save Note
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Print Script -->
<script>
    function printNote() {
        const title = document.getElementById('noteTitle').value;
        const note = document.getElementById('noteText').value;

        if (!title && !note) {
            alert('Please enter something to print.');
            return;
        }

        const popup = window.open('', '_blank', 'width=400,height=600');
        popup.document.write(`
            <html>
            <head>
                <title>Note Print</title>
                <style>
                    body { font-family: 'Noto Nastaliq Urdu', 'Arial', sans-serif; direction: rtl; padding: 10px; font-size: 14px; }
                    h2 { font-size: 16px; margin-bottom: 10px; }
                </style>
            </head>
            <body onload="window.print(); window.close();">
                <h2>Title: ${title}</h2>
                <p> <strong>Note</strong> :${note.replace(/\n/g, '<br>')}</p>
            </body>
            </html>
        `);
        popup.document.close();
    }
</script>

<!-- Urdu Font Support -->
<style>
    .urdu-font {
        font-family: 'Noto Nastaliq Urdu', 'Jameel Noori Nastaleeq', 'Arial', sans-serif;
        direction: rtl;
    }

    @media print {
        body * {
            visibility: hidden;
        }
        form, form * {
            visibility: visible;
        }
        form {
            position: absolute;
            left: 0;
            top: 0;
            width: 58mm;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\notes.blade.php ENDPATH**/ ?>