<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">

    <div id="receipt">
        <?php $__currentLoopData = ['Department Copy', 'Customer Copy']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $copyType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="copy-page mb-12 <?php echo e($index === 1 ? 'relative pt-20' : ''); ?>">
            
            <?php if($index === 1): ?>
            <!-- Separation Line -->
            <div class="absolute top-10 left-0 w-full flex items-center justify-center print:block  my-5">
                <div class="w-full border-t-2 border-dashed border-gray-500 print:mt-10 mb-10"></div>
                <div class="absolute -top-10 left-1/2 transform -translate-x-1/2 bg-white px-2 text-sm font-semibold text-gray-500 my-5">
                    Tear Here
                </div>
            </div>
            <?php endif; ?>

            <!-- Header Section -->
           <div id="storeHeader<?php echo e($index); ?>" class="text-center mb-6">
    <?php if($printSetting->logo_path): ?>
        <img id="headerLogo<?php echo e($index); ?>" src="<?php echo e(asset('storage/' . $printSetting->logo_path)); ?>" alt="Store Logo" class="mx-auto mb-4" style="max-width: 150px; height: auto;">
    <?php endif; ?>
    <h1 id="headerTitle<?php echo e($index); ?>" class="text-3xl font-bold"><?php echo e($printSetting->title); ?></h1>
    <p id="headerAddress<?php echo e($index); ?>" class="text-lg text-gray-800 font-bold"><?php echo e($printSetting->address); ?></p>
    <p id="headerPhone<?php echo e($index); ?>" class="text-lg text-gray-800 font-bold">Phone: <?php echo e($printSetting->phone); ?></p>
    <p id="copyType<?php echo e($index); ?>" class="mt-2 text-xl font-bold  uppercase"><?php echo e($copyType); ?></p>
</div>


            <!-- Bill Info -->
            <div class="border-t border-b py-4 mb-4 text-lg">
                <?php
    $details = [
        'Bill ID' => $bill->id,
        'Customer Name' => $bill->customer_name ?? 'N/A',
        'Date' => $bill->date,
        'Payment Type' => $bill->payment,
        'Total Amount' => 'Rs. ' . $bill->total_amount,
        'Remarks' => $bill->remarks ?? 'N/A',
        'Price Type' => isset($bill->price_type) ? ucfirst(substr($bill->price_type, 0, 1)) : 'N/A',
    ];
?>
                <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex justify-between mb-2">
                        <div class="font-bold"><?php echo e($label); ?>:</div>
                        <div class="text-right font-bold"><?php echo e($value); ?></div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Items Table -->
            <div class="mb-6">
                <h2 class="text-xl font-semibold mb-2">Bill Items</h2>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-lg text-left border">
                        <thead class="bg-gray-100 font-semibold">
                            <tr>
                                <th class="border px-4 py-2">#</th>
                                <th class="border px-4 py-2">Product</th>
                                <th class="border px-4 py-2">Qty</th>
                                <th class="border px-4 py-2">Unit Price</th>
                                <th class="border px-4 py-2">Total</th>
                            </tr>
                        </thead>
                        <tbody class="font-semibold">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="border px-4 py-2"><?php echo e($i + 1); ?></td>
                                <td class="border px-4 py-2">
                                    <?php echo e($bill->print_type === 'by_salt' ? ($item->product->salt ?? 'N/A') : ($item->product->name ?? 'N/A')); ?>

                                </td>
                                <td class="border px-4 py-2"><?php echo e($item->qty); ?></td>
                                <td class="border px-4 py-2">Rs. <?php echo e($item->price); ?></td>
                                <td class="border px-4 py-2">Rs. <?php echo e($item->amount); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Store Footer Note -->
            <div class="mt-4 text-base text-gray-800 font-bold">
                <p><strong>Note:</strong> <?php echo e($printSetting->footer_note); ?></p>
            </div>

            <!-- Goodbye Message -->
            <div class="mt-6 text-center font-bold text-lg">
                <p><?php echo e($printSetting->goodbye_message); ?></p>
            </div>

            <!-- Software Credit -->
            <div class="mt-10 pt-4 border-t text-center text-sm text-gray-600 print:text-black">
                <p class="mb-1 font-bold">Software developed by <span class="font-bold text-gray-800">Next Steps Sols Pvt. Ltd.</span></p>
                <p class="mb-1 font-bold">🌐 <a href="https://www.nextstepsols.com" class=" hover:underline" target="_blank">www.nextstepsols.com</a></p>
                <p class='font-bold'>📞 Cell: 0332-0679987</p>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Action Buttons -->
    <div class="mt-6 flex justify-center space-x-4 print:hidden">
        <button onclick="setbillPrintMode(true)" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
            Detailed Print
        </button>
        <button onclick="setbillPrintMode(false)" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded">
            Simple Print
        </button>
        <button onclick="handlePrint(<?php echo e($bill->id); ?>, '<?php echo e($bill->status); ?>')" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
            Print
        </button>
        <a href="<?php echo e(route('bill.pending', $bill->id)); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">
            Pending
        </a>
    </div>
<script>

function setbillPrintMode(detailed) {
    for (let i = 0; i < 2; i++) {
        const logo = document.getElementById(`headerLogo${i}`);
        const title = document.getElementById(`headerTitle${i}`);
        const address = document.getElementById(`headerAddress${i}`);
        const phone = document.getElementById(`headerPhone${i}`);
        const copyType = document.getElementById(`copyType${i}`);
        const goodbye = document.getElementById(`goodbyeMessage${i}`);
        const software = document.getElementById(`softwareCredit${i}`);
        const header = document.getElementById(`storeHeader${i}`);

        if (detailed) {
            logo && (logo.style.display = 'block');
            title && (title.style.display = 'block');
            address && (address.style.display = 'block');
            phone && (phone.style.display = 'block');
            copyType && (copyType.style.display = 'block');
            // goodbye && (goodbye.style.display = 'block');
            // software && (software.style.display = 'block');
            // header && (header.style.justifyContent = 'center');
        } else {
            logo && (logo.style.display = 'none');
            title && (title.style.display = 'none');
            address && (address.style.display = 'none');
            phone && (phone.style.display = 'none');
            copyType && (copyType.style.display = 'block');
            // goodbye && (goodbye.style.display = 'block');
            // software && (software.style.display = 'block');
             header && (header.style.justifyContent = 'center');
        }
    }
}




</script>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/bill/print-view.blade.php ENDPATH**/ ?>