

<?php $__env->startSection('content'); ?>
<div class="p-4">
    <h2 class="text-3xl font-bold text-gray-800 mb-6">All Credit Details</h2>

    <!-- Search Form -->
    <!-- <form method="GET" action="<?php echo e(route('company.search')); ?>" class="mb-6">
        <div class="flex items-center max-w-xl space-x-2">
            <input type="text" name="search" placeholder="Search by name or phone..." value="<?php echo e(request('search')); ?>"
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-200 focus:outline-none" />
            <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                Search
            </button>
        </div>
    </form> -->

    <!-- No Results Message -->
    <?php if(request('search') && $suppliers->isEmpty()): ?>
        <div class="text-red-500 mb-4">No results found for "<?php echo e(request('search')); ?>".</div>
    <?php endif; ?>

    <!-- Table -->
    <div class="w-full overflow-x-auto">
        <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap shadow-lg rounded-lg overflow-hidden">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="px-4 py-2">ID</th>
                    <th class="px-4 py-2">Supplier Name</th>
                    <th class="px-4 py-2">Phone</th>
                    
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b hover:bg-gray-50">
                        <td class="px-4 py-2"><?php echo e($supplier->id); ?></td>
                        <td class="px-4 py-2"><?php echo e($supplier->supplier_name); ?></td>
                        <td class="px-4 py-2"><?php echo e($supplier->phone); ?></td>
                        <td class="px-4 py-2 space-x-2">
                            <button
                                onclick="openModal(this)"
                                class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600"
                                data-id="<?php echo e($supplier->id); ?>"
                                data-name="<?php echo e($supplier->supplier_name); ?>"
                                data-phone="<?php echo e($supplier->phone); ?>"
                               
                            >
                                Edit
                            </button>

                            <form action="<?php echo e(route('supplier.delete', $supplier->id)); ?>" method="POST" class="inline-block">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-gray-500 py-4">No records found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-40">
        <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl relative">
            <button onclick="closeModal()"
                    class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-2xl font-bold">
                &times;
            </button>
            <h3 class="text-xl font-semibold mb-4 text-gray-800">Update Company</h3>

            <form id="editForm" method="POST" action="">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Supplier Name</label>
                    <input type="text" name="supplier_name" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Supplier Phone</label>
                    <input type="text" name="phone" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700 transition duration-200">
                    Update
                </button>
            </form>
        </div>
    </div>

</div>

<!-- JavaScript -->
<script>
    function openModal(button) {
        const modal = document.getElementById('editModal');
        const form = document.getElementById('editForm');

        // Set form action dynamically
        const companyId = button.getAttribute('data-id');
        form.action = `/supplier/update/${companyId}`;

        // Set input values
        form.querySelector('[name="supplier_name"]').value = button.getAttribute('data-name');
        form.querySelector('[name="phone"]').value = button.getAttribute('data-phone');
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    function closeModal() {
        const modal = document.getElementById('editModal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/supplier/index.blade.php ENDPATH**/ ?>