

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto mt-10 p-4 sm:p-6 bg-white rounded-xl shadow-md">
    <h2 class="text-2xl font-semibold mb-6 text-center sm:text-left">My Profile</h2>

    <!-- Responsive Table or Stacked Info -->
    <div class="overflow-x-auto hidden sm:block">
        <table class="min-w-full border text-left text-sm mb-8">
            <thead class="bg-gray-100 text-gray-700">
                <tr>
                    <th class="py-2 px-4 border-b">Name</th>
                    <th class="py-2 px-4 border-b">Email</th>
                    <th class="py-2 px-4 border-b">Role</th>
                    <th class="py-2 px-4 border-b">Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="py-2 px-4 border-b"><?php echo e($user->name); ?></td>
                    <td class="py-2 px-4 border-b"><?php echo e($user->email); ?></td>
                    <td class="py-2 px-4 border-b capitalize"><?php echo e($user->role); ?></td>
                    <td class="py-2 px-4 border-b">
                        <a href="<?php echo e(route('profile.edit')); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">Edit</a>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Stacked view for mobile -->
    <div class="sm:hidden space-y-4 mb-8">
        <div class="border rounded p-4 shadow-sm bg-gray-50">
            <p><strong>Name:</strong> <?php echo e($user->name); ?></p>
            <p><strong>Email:</strong> <?php echo e($user->email); ?></p>
            <p><strong>Role:</strong> <span class="capitalize"><?php echo e($user->role); ?></span></p>
            <a href="<?php echo e(route('profile.edit')); ?>"  target="_blank" class="inline-block mt-3 bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">Edit</a>
        </div>
    </div>

    <!-- Change Password Section -->
    <div>
        <h3 class="text-xl font-semibold mb-4">Change Password</h3>

        <?php if(session('success')): ?>
            <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="mb-4 p-3 bg-red-100 text-red-700 rounded">
                <ul class="list-disc ml-5">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('profile.change-password')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-4">
                <label class="block mb-1 font-medium">Current Password</label>
                <input type="password" name="current_password" class="w-full border px-3 py-2 rounded" required>
            </div>

            <div class="mb-4">
                <label class="block mb-1 font-medium">New Password</label>
                <input type="password" name="new_password" class="w-full border px-3 py-2 rounded" required>
            </div>

            <div class="mb-6">
                <label class="block mb-1 font-medium">Confirm New Password</label>
                <input type="password" name="new_password_confirmation" class="w-full border px-3 py-2 rounded" required>
            </div>

            <button type="submit" class="w-full sm:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-2 rounded">
                Update Password
            </button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/profile/index.blade.php ENDPATH**/ ?>