<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-4 py-6">

    <h1 class="text-2xl font-bold mb-4 text-center">Search Product for Return</h1>

    
    <form method="GET" action="<?php echo e(route('products.searchBillItems')); ?>" class="mb-6">
        <div class="flex flex-col sm:flex-row gap-2">
                  <div class="relative w-full">
        <input 
            type="text" 
            name="q" value="<?php echo e(old('q', $query ?? '')); ?>"
            id="liveBillSearchInput"
            placeholder="Search by customer, bill #, product..." 
            class="w-full px-4 py-2 border border-gray-300 rounded shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-300 text-sm"
            oninput="handleBillLiveSearch(this.value)"
            autocomplete="off"
        >
        <!-- Suggestion box -->
        <div id="billLiveResultContainer"
             class="absolute top-full left-0 w-full bg-white border border-gray-300 rounded shadow text-sm z-20 hidden max-h-64 overflow-y-auto">
        </div>
    </div>
            <button type="submit"
                class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                Search
            </button>
        </div>
    </form>

    
    <?php if(isset($billItems)): ?>
        <h2 class="text-lg font-semibold mb-3">Search Results from Bills</h2>
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3 mb-6">
            <?php $__currentLoopData = $billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $product = $billItem->product;
                    $customer = $billItem->bill->customer;

                    $productJson = json_encode([
                        'id' => $product->id,
                        'name' => $product->name,
                        'company' => $product->company,
                        'unit_type' => $product->unit_type,
                        'salt' => $product->salt,
                        'stock' => $product->quantity,
                        'category' => is_array($product->categories) ? implode(', ', $product->categories) : $product->categories,
                        'bill_item_id' => $billItem->id, 
            'max_qty' => $billItem->qty
                    ]);
                ?>

                <div class="border p-4 rounded shadow bg-white">
                    <p class="font-bold text-lg"><?php echo e($product->name); ?></p>
                    <p class="text-sm text-gray-500">Company: <?php echo e($product->company); ?></p>
                    <p class="text-sm text-gray-500">Customer: <?php echo e($billItem->bill->customer_name); ?></p>
                    <p class="text-sm text-gray-500">Bill ID: <?php echo e($billItem->bill_id); ?></p>
                    <p class="text-sm text-gray-500">Qty Purchased: <?php echo e($billItem->qty); ?></p>

                    <button type="button"
                        onclick='addToCart(<?php echo $productJson; ?>)'
                        class="mt-3 bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700 w-full">
                        Return Product
                    </button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    
    <h2 class="text-xl font-semibold mb-3">Return Cart</h2>
    <form method="POST" action="<?php echo e(route('product.return')); ?>" id="bill-form">
        <?php echo csrf_field(); ?>
        <div id="cart-container" class="space-y-4"></div>

        <button type="submit"
            class="mt-4 bg-indigo-600 text-white px-6 py-2 rounded hover:bg-indigo-700 hidden"
            id="submit-btn">
            Submit Return
        </button>
    </form>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    let cart = JSON.parse(localStorage.getItem('cart')) || [];

    function saveCart() {
        localStorage.setItem('cart', JSON.stringify(cart));
    }

    function addToCart(product) {
        // Check if same product from same bill already exists
        const exists = cart.some(item => 
            item.id === product.id && item.bill_item_id === product.bill_item_id
        );
        
        if (exists) {
            alert('This product from this bill is already in your return cart');
            return;
        }

        cart.push({
            ...product,
            qty: 1
        });
        saveCart();
        renderCart();
    }

    function removeFromCart(productId, billItemId) {
        cart = cart.filter(p => !(p.id === productId && p.bill_item_id === billItemId));
        saveCart();
        renderCart();
    }
    
    function renderCart() {
        const container = document.getElementById('cart-container');
        container.innerHTML = '';
        
        if (cart.length === 0) {
            document.getElementById('submit-btn').classList.add('hidden');
            return;
        }
        
        document.getElementById('submit-btn').classList.remove('hidden');

        cart.forEach((product, index) => {
            const item = document.createElement('div');
            item.className = 'p-4 border rounded bg-gray-50 shadow flex flex-col sm:flex-row justify-between items-center gap-2';
            item.innerHTML = `
                <div>
                    <input type="hidden" name="products[${index}][product_id]" value="${product.id}">
                    <input type="hidden" name="products[${index}][bill_item_id]" value="${product.bill_item_id}">
                    <p class="font-bold">${product.name}</p>
                    <p class="text-sm text-gray-500">Bill Item: ${product.bill_item_id} | Max: ${product.max_qty}</p>
                    <p class="text-sm text-gray-500">${product.company} | ${product.category}</p>
                </div>
                <div class="flex items-center gap-2">
                    <label class="text-sm">Qty:</label>
                    <input type="number" name="products[${index}][qty]" 
                           value="1" min="1" max="${product.max_qty}" 
                           class="w-20 p-1 border rounded">
                    <button type="button" onclick="removeFromCart(${product.id}, ${product.bill_item_id})"
                        class="text-red-600 text-sm hover:underline">Remove</button>
                </div>
            `;
            container.appendChild(item);
        });
    }

    // Render cart on page load
    document.addEventListener("DOMContentLoaded", renderCart);

    // Enhanced form submission handler
    document.getElementById('bill-form').addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const submitBtn = document.getElementById('submit-btn');
        const originalBtnText = submitBtn.innerHTML;
        submitBtn.disabled = true;
        submitBtn.innerHTML = `
            <span class="inline-block animate-spin">🔄</span> Processing...
        `;
        
        try {
            // Manually collect form data
            const formData = {
                products: Array.from(document.querySelectorAll('#cart-container [name^="products"]'))
                    .reduce((acc, input) => {
                        const matches = input.name.match(/products\[(\d+)\]\[(\w+)\]/);
                        if (matches) {
                            const index = matches[1];
                            const field = matches[2];
                            if (!acc[index]) acc[index] = {};
                            acc[index][field] = input.value;
                        }
                        return acc;
                    }, [])
                    .filter(item => item) // Remove empty items
            };

            // Make the API request
            const response = await fetch(this.action, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Accept': 'application/json'
                },
                body: JSON.stringify(formData)
            });

            const result = await response.json();

            if (!response.ok) {
                throw new Error(result.message || 'Server returned an error');
            }

            if (result.success) {
    alert(result.message); // Show success message
    localStorage.removeItem('cart');
    window.location.href = result.redirect; // Then redirect
}

else {
                throw new Error(result.message);
            }
            
        } catch (error) {
            console.error('Return processing error:', error);
            alert(error.message);
            
            // Restore button state
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalBtnText;
        }
    });
  let billSelectedIndex = -1;
let billCurrentSuggestions = [];

function handleBillLiveSearch(query) {
    const resultBox = document.getElementById('billLiveResultContainer');

    if (query.length < 1) {
        resultBox.classList.add('hidden');
        resultBox.innerHTML = '';
        billCurrentSuggestions = [];
        billSelectedIndex = -1;
        return;
    }

    fetch(`/return-bill-search-suggestions?query=${encodeURIComponent(query)}`)
        .then(res => {
            if (!res.ok) throw new Error('Network response was not ok');
            return res.json();
        })
        .then(data => {
            billCurrentSuggestions = data;
            billSelectedIndex = -1;

            if (!data || data.length === 0) {
                resultBox.classList.add('hidden');
                resultBox.innerHTML = '';
                return;
            }

            resultBox.innerHTML = data.map((item, index) => `
                <div 
                    class="px-3 py-2 suggestion-item cursor-pointer"
                    data-index="${index}"
                    onclick="selectBillSuggestion('${item.replace(/'/g, "\\'")}')"
                >${item}</div>
            `).join('');

            resultBox.classList.remove('hidden');
        })
        .catch(error => {
            console.error('Error fetching suggestions:', error);
            resultBox.classList.add('hidden');
        });
}

function selectBillSuggestion(value) {
    const input = document.getElementById('liveBillSearchInput');
    input.value = value;
    const resultBox = document.getElementById('billLiveResultContainer');
    resultBox.classList.add('hidden');
    resultBox.innerHTML = '';
    input.focus();
}

function updateBillActiveItem(items) {
    items.forEach((item, index) => {
        if (index === billSelectedIndex) {
            item.classList.add('bg-blue-100');
            item.scrollIntoView({ block: 'nearest' });
        } else {
            item.classList.remove('bg-blue-100');
        }
    });
}

document.addEventListener('DOMContentLoaded', function () {
    const input = document.getElementById('liveBillSearchInput');

    if (input) {
        input.addEventListener('input', function (e) {
            handleBillLiveSearch(e.target.value);
        });

        input.addEventListener('keydown', function (e) {
            const resultBox = document.getElementById('billLiveResultContainer');
            const items = resultBox.querySelectorAll('[data-index]');

            if (resultBox.classList.contains('hidden') || items.length === 0) return;

            if (e.key === 'ArrowDown') {
                e.preventDefault();
                billSelectedIndex = (billSelectedIndex + 1) % items.length;
                document.body.classList.add('using-keyboard');
                updateBillActiveItem(items);
            } else if (e.key === 'ArrowUp') {
                e.preventDefault();
                billSelectedIndex = (billSelectedIndex - 1 + items.length) % items.length;
                document.body.classList.add('using-keyboard');
                updateBillActiveItem(items);
            } else if (e.key === 'Enter' && billSelectedIndex >= 0) {
                e.preventDefault();
                const selectedItem = billCurrentSuggestions[billSelectedIndex];
                selectBillSuggestion(selectedItem);
            }
        });
    }
});

// Hide suggestions on outside click
document.addEventListener('click', function (e) {
    const input = document.getElementById('liveBillSearchInput');
    const resultBox = document.getElementById('billLiveResultContainer');
    if (!input.contains(e.target) && !resultBox.contains(e.target)) {
        resultBox.classList.add('hidden');
    }
});

// Switch between mouse and keyboard control
let usingKeyboard = false;

document.addEventListener('keydown', (e) => {
    if (['ArrowUp', 'ArrowDown'].includes(e.key)) {
        usingKeyboard = true;
        document.body.classList.add('using-keyboard');
    }
});

document.addEventListener('mousemove', () => {
    if (usingKeyboard) {
        usingKeyboard = false;
        document.body.classList.remove('using-keyboard');
    }
})
</script>
<style>
    body.using-keyboard #billLiveResultContainer .suggestion-item:hover {
    background-color: inherit !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/product/return.blade.php ENDPATH**/ ?>