

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6">
    <h1 class="text-2xl font-semibold mb-4">Cash Out Report</h1>

    <!-- Date Filter Form -->
    <div class="bg-white p-4 rounded-lg shadow-md mb-6">
        <form method="GET" action="<?php echo e(route('cash-out')); ?>" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="w-full md:w-auto">
                <label for="start_date" class="block text-sm font-medium text-gray-700">From Date</label>
                <input type="date" id="start_date" name="start_date" 
                       value="<?php echo e(request('start_date')); ?>" 
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            
            <div class="w-full md:w-auto">
                <label for="end_date" class="block text-sm font-medium text-gray-700">To Date</label>
                <input type="date" id="end_date" name="end_date" 
                       value="<?php echo e(request('end_date')); ?>" 
                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            
            <button type="submit" 
                    class="w-full md:w-auto px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                Filter
            </button>
            
            <?php if(request()->has('start_date')): ?>
            <a href="<?php echo e(route('cash-out')); ?>" 
               class="w-full md:w-auto px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2">
                Clear Filters
            </a>
            <?php endif; ?>
        </form>
    </div>

    <!-- Tabs Navigation -->
    <div class="mb-4 border-b border-gray-200">
        <ul class="flex flex-wrap -mb-px" id="cashOutTabs" role="tablist">
            <li class="mr-2" role="presentation">
                <button class="inline-block p-4 border-b-2 rounded-t-lg" 
                        id="suppliers-tab" data-tabs-target="#suppliers" type="button" role="tab" 
                        aria-controls="suppliers" aria-selected="true">
                    Supplier Payments
                </button>
            </li>
            <li class="mr-2" role="presentation">
                <button class="inline-block p-4 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300" 
                        id="expenses-tab" data-tabs-target="#expenses" type="button" role="tab" 
                        aria-controls="expenses" aria-selected="false">
                    Extra Expenses
                </button>
            </li>
        </ul>
    </div>

    <!-- Tabs Content -->
    <div id="cashOutTabsContent">
        <!-- Supplier Payments Tab -->
        <div class="hidden p-4 rounded-lg bg-white" id="suppliers" role="tabpanel" aria-labelledby="suppliers-tab">
            <?php if($supplierPayments->isNotEmpty()): ?>
                <?php
                    $paidTotal = $supplierPayments->sum('paid_amount');
                    $dueTotal = $supplierPayments->sum('due_amount');
                ?>
                
                <div class="overflow-hidden">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Supplier</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Company</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Bill</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $supplierPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($payment['supplier_name']); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($payment['company_name']); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($payment['product_name']); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. <?php echo e(number_format($payment['total_bill'], 2)); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. <?php echo e(number_format($payment['paid_amount'], 2)); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. <?php echo e(number_format($payment['due_amount'], 2)); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e(Carbon\Carbon::parse($payment['stock_date'])->format('Y-m-d')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="bg-gray-50 font-semibold">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900" colspan="4">Total Paid Payments</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. <?php echo e(number_format($paidTotal, 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                            </tr>
                            <tr class="bg-gray-50 font-semibold">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900" colspan="5">Total Due Payments</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. <?php echo e(number_format($dueTotal, 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="p-6 rounded-lg shadow-md text-center">
                    <p class="text-gray-600">No supplier payments recorded for the selected date range.</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Extra Expenses Tab -->
        <div class="hidden p-4 rounded-lg bg-white" id="expenses" role="tabpanel" aria-labelledby="expenses-tab">
            <?php if($extraExpenses->isNotEmpty()): ?>
                <?php
                    $expenseTotal = $extraExpenses->sum('amount');
                ?>
                
                <div class="overflow-hidden">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $extraExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($expense['description']); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"> Rs. <?php echo e(number_format($expense['amount'], 2)); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e(Carbon\Carbon::parse($expense['expense_date'])->format('Y-m-d')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="bg-gray-50 font-semibold">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Total Extra Expenses</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">Rs. <?php echo e(number_format($expenseTotal, 2)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="p-6 rounded-lg shadow-md text-center">
                    <p class="text-gray-600">No extra expenses recorded for the selected date range.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Tabbed Interface Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const tabs = document.querySelectorAll('[data-tabs-target]');
    const tabContents = document.querySelectorAll('[role="tabpanel"]');

    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            const target = document.querySelector(tab.dataset.tabsTarget);
            
            // Hide all tab contents
            tabContents.forEach(content => {
                content.classList.add('hidden');
            });
            
            // Show the selected tab content
            target.classList.remove('hidden');
            
            // Update active tab styling
            tabs.forEach(t => {
                t.classList.remove('border-blue-500', 'text-blue-600');
                t.classList.add('border-transparent');
            });
            
            tab.classList.add('border-blue-500', 'text-blue-600');
            tab.classList.remove('border-transparent');
        });
    });

    // Activate the first tab by default
    document.querySelector('[data-tabs-target="#suppliers"]').click();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\supplier\cash-out.blade.php ENDPATH**/ ?>