

<?php $__env->startSection('content'); ?>
<div class="p-4">
    <h2 class="text-3xl font-bold text-gray-800 mb-6">All Credit Details</h2>

    <!-- Search Form -->
    <form method="GET" action="<?php echo e(route('credit.search')); ?>" class="mb-6">
        <div class="flex items-center max-w-xl space-x-2">
            <input type="text" name="search" placeholder="Search by name or phone..." value="<?php echo e(request('search')); ?>"
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-200 focus:outline-none" />
            <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                Search
            </button>
        </div>
    </form>

    <!-- Table -->
    <div class="w-full overflow-x-auto">
        <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap shadow-lg rounded-lg overflow-hidden">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="px-4 py-2">ID</th>
                    <th class="px-4 py-2">Customer Name</th>
                    <th class="px-4 py-2">Customer Phone</th>
                    <th class="px-4 py-2">Address</th>
                    <th class="px-4 py-2">Due Amount</th>
                    <th class="px-4 py-2">Paid Amount</th>
                    <th class="px-4 py-2">Date</th>
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b hover:bg-gray-50">
                        <td class="px-4 py-2"><?php echo e($credit->id); ?></td>
                        <td class="px-4 py-2"><?php echo e($credit->customer->name); ?></td>
                        <td class="px-4 py-2"><?php echo e($credit->customer->phone); ?></td>
                        <td class="px-4 py-2"><?php echo e($credit->customer->address); ?></td>
                        <td class="px-4 py-2"><?php echo e($credit->due_amount ?? 'N/A'); ?></td>
                        <td class="px-4 py-2"><?php echo e($credit->is_paid); ?></td>
                        <td class="px-4 py-2"><?php echo e($credit->updated_at); ?></td>
                        <td class="px-4 py-2 space-x-2">
    <button onclick="openModal(<?php echo e($credit->id); ?>)"
            class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600">
        Edit
    </button>
    <form action="<?php echo e(route('credit.delete', $credit->id)); ?>" method="POST" class="inline-block">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600" onclick="return confirm('Are you sure?')">Delete</button>
    </form>
    <a href="<?php echo e(route('credit.print', $credit->id)); ?>" target="_blank"
       class="bg-green-500 text-white px-3 py-1 rounded hover:bg-yellow-600">
        Print
    </a>
</td>
</tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center text-gray-500 py-4">No records found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-40">
        <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl relative">
            <button onclick="closeModal()"
                    class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-2xl font-bold">
                &times;
            </button>
            <h3 class="text-xl font-semibold mb-4 text-gray-800">Update Due Amount</h3>
            <form id="editForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="mb-4">
                    <label for="due_amount" class="block text-sm font-medium text-gray-700">Enter New Amount</label>
                    <input type="number" name="due_amount" id="due_amount" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700 transition duration-200">
                    Update
                </button>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
    function openModal(creditId) {
        const modal = document.getElementById('editModal');
        const form = document.getElementById('editForm');

        // Update form action
        form.action = `/credit/update/${creditId}`;

        // Show modal
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    function closeModal() {
        const modal = document.getElementById('editModal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\bill\credit\showCredit.blade.php ENDPATH**/ ?>