

<?php $__env->startSection('content'); ?>
<div class="p-4">
    <h2 class="text-3xl font-bold text-gray-800 mb-6">All Credit Details</h2>

    <!-- Search Form -->
    <form method="GET" action="<?php echo e(route('ledger.show')); ?>" class="mb-6" id="searchForm">
        <input type="hidden" name="company_filter" id="companyFilterInput" value="<?php echo e(request('company_filter')); ?>">
        <div class="flex items-center space-x-2">
            <input type="text" name="search" placeholder="Search by name or phone..." value="<?php echo e(request('search')); ?>"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-200 focus:outline-none" />
            <button type="submit"
                class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                Search
            </button>
            <?php if(request('search') || request('company_filter')): ?>
            <a href="<?php echo e(route('ledger.show')); ?>" 
               class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-200">
                Clear
            </a>
            <?php endif; ?>
        </div>
    </form>

    <?php if(request('search') && $ledgers->isEmpty()): ?>
        <div class="text-red-500 mb-4">No results found for "<?php echo e(request('search')); ?>".</div>
    <?php endif; ?>

    <!-- Table -->
    <div class="w-full overflow-x-auto">
        <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap shadow-lg rounded-lg overflow-hidden">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="px-4 py-2">ID</th>
                    <th class="px-4 py-2">Image</th>
                    <th class="px-4 py-2">Company Name</th>
                    <th class="px-4 py-2">Supplier Name</th>
                    <th class="px-4 py-2">Stock</th>
                    <th class="px-4 py-2">Total Bill</th>
                    <th class="px-4 py-2">Stock Date</th>
                    <th class="px-4 py-2">Payment</th>
                    <th class="px-4 py-2">Payment Date</th>
                    <th class="px-4 py-2">Due Amount</th>
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody id="demandsTableBody">
                <?php $__empty_1 = true; $__currentLoopData = $ledgers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ledger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b hover:bg-gray-50">
                        <td class="px-4 py-2"><?php echo e($ledger->id); ?></td>
                        <td class="px-4 py-2">
    <?php if($ledger->image): ?>
        <img src="<?php echo e(asset('storage/' . $ledger->image)); ?>" alt="Image" class="w-16 h-16 object-cover rounded" />
    <?php else: ?>
        <span class="text-gray-400">No Image</span>
    <?php endif; ?>
</td>

                        <td class="px-4 py-2"><?php echo e($ledger->company?->company_name ?? 'N/A'); ?></td>
                        <td class="px-4 py-2"><?php echo e($ledger->supplier?->supplier_name ?? 'N/A'); ?></td>
                        <td class="px-4 py-2"><?php echo e($ledger->products); ?></td>
                        <td class="px-4 py-2"><?php echo e($ledger->total_bill); ?></td>
                        <td class="px-4 py-2"><?php echo e($ledger->stock_date); ?></td>
                        <td class="px-4 py-2"><?php echo e($ledger->paid_amount); ?></td>
                        <td class="px-4 py-2"><?php echo e($ledger->payment_date); ?></td>
                        <td class="px-4 py-2"><?php echo e($ledger->due_amount); ?></td>
                        <td class="px-4 py-2 space-x-2">
                            <button onclick="openModal(this)"
                                data-id="<?php echo e($ledger->id); ?>"
                                data-name="<?php echo e($ledger->products); ?>"
                                data-company-id="<?php echo e($ledger->company_id); ?>"
                                data-supplier-id="<?php echo e($ledger->supplier_id); ?>"
                                data-bill="<?php echo e($ledger->total_bill); ?>"
                                data-stock-date="<?php echo e($ledger->stock_date); ?>"
                                data-paid-amount="<?php echo e($ledger->paid_amount); ?>"
                                data-payment-date="<?php echo e($ledger->payment_date); ?>"
                                data-due-amount="<?php echo e($ledger->due_amount); ?>"
                                class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600">
                                Edit
                            </button>

                            <form action="<?php echo e(route('ledger.delete', $ledger->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this record?');" style="display: inline;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
    <button type="submit" class="text-red-600 hover:text-red-800 font-semibold">
        Delete
    </button>
</form>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="10" class="text-center text-gray-500 py-4">No records found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Edit Modal -->
<div id="editModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-40 overflow-y-auto py-10">
    <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl relative my-8 mx-auto">
        <button onclick="closeModal()"
                class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-2xl font-bold">
            &times;
        </button>
        <h3 class="text-xl font-semibold mb-4 text-gray-800">Update Demand</h3>

        <form id="editForm" method="POST" action="" class="max-h-[70vh] overflow-y-auto pr-2">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    <div class="mb-4">
        <label class="block text-sm font-medium text-gray-700">Product Name</label>
        <input type="text" name="product_name" required 
               class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
    </div>

    <div class="flex gap-4 mb-4">
        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Company</label>
            <select name="company_id" 
                    class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm">
                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Supplier</label>
            <select name="supplier_id" 
                    class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm">
                <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->supplier_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <div class="flex gap-4 mb-4">
        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Stock</label>
            <input type="text" name="products" required 
                   class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
        </div>

        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Total Bill</label>
            <input type="number" name="total_bill" required 
                   class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
        </div>
    </div>

    <div class="flex gap-4 mb-4">
        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Stock Date</label>
            <input type="date" name="stock_date" 
                   class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
        </div>

        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Paid Amount</label>
            <input type="number" name="paid_amount" 
                   class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
        </div>
    </div>

    <div class="flex gap-4 mb-4">
        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Payment Date</label>
            <input type="date" name="payment_date" 
                   class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
        </div>

        <div class="w-1/2">
            <label class="block text-sm font-medium text-gray-700">Due Amount</label>
            <input type="number" name="due_amount" 
                   class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
        </div>
    </div>

    <button type="submit"
        class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700 transition duration-200 w-full">
        Update
    </button>
</form>

    </div>
</div>

<style>
    .filter-btn {
        transition: all 0.3s ease;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .filter-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 6px rgba(0,0,0,0.15);
    }
    .filter-btn.active {
        background-color: #2563eb;
        color: white;
        font-weight: 600;
    }
    
    /* Custom scrollbar for modal */
    #editForm::-webkit-scrollbar {
        width: 6px;
    }
    #editForm::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }
    #editForm::-webkit-scrollbar-thumb {
        background: #c1c1c1;
        border-radius: 10px;
    }
    #editForm::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8;
    }
</style>

<script>
    // Filter demands by company
    function filterDemands(companyId) {
        // Update active button
        document.querySelectorAll('.filter-btn').forEach(btn => {
            btn.classList.remove('active', 'bg-blue-600', 'text-white');
            btn.classList.add('bg-gray-200', 'text-gray-800');
        });
        
        // Set active button
        if (companyId === 'all') {
            document.querySelector('.filter-btn:first-child').classList.add('active', 'bg-blue-600', 'text-white');
        } else {
            document.querySelector(`.filter-btn[data-company="${companyId}"]`).classList.add('active', 'bg-blue-600', 'text-white');
        }
        
        // Set hidden input for form submission
        document.getElementById('companyFilterInput').value = companyId === 'all' ? '' : companyId;
        
        // Clear search input when changing filters
        document.querySelector('[name="search"]').value = '';
        
        // Submit the form to refresh with filtered results
        document.getElementById('searchForm').submit();
    }

    // Initialize active filter button based on current filter
    document.addEventListener('DOMContentLoaded', function() {
        const currentFilter = "<?php echo e(request('company_filter')); ?>";
        if (currentFilter) {
            document.querySelector(`.filter-btn[data-company="${currentFilter}"]`).classList.add('active', 'bg-blue-600', 'text-white');
        } else {
            document.querySelector('.filter-btn:first-child').classList.add('active', 'bg-blue-600', 'text-white');
        }
    });

    function openModal(button) {
        const modal = document.getElementById('editModal');
        const form = document.getElementById('editForm');

        const id = button.getAttribute('data-id');
        form.action = `/ledger/update/${id}`;

        // Fill values into the form fields
        form.querySelector('[name="product_name"]').value = button.getAttribute('data-name');
        form.querySelector('[name="company_id"]').value = button.getAttribute('data-company-id');
        form.querySelector('[name="supplier_id"]').value = button.getAttribute('data-supplier-id');
        form.querySelector('[name="products"]').value = button.getAttribute('data-name');
        form.querySelector('[name="total_bill"]').value = button.getAttribute('data-bill');
        form.querySelector('[name="stock_date"]').value = button.getAttribute('data-stock-date');
        form.querySelector('[name="paid_amount"]').value = button.getAttribute('data-paid-amount');
        form.querySelector('[name="payment_date"]').value = button.getAttribute('data-payment-date');
        form.querySelector('[name="due_amount"]').value = button.getAttribute('data-due-amount');

        modal.classList.remove('hidden');
        modal.classList.add('flex');
        document.body.style.overflow = 'hidden';
    }

    function closeModal() {
        const modal = document.getElementById('editModal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
        document.body.style.overflow = 'auto';
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\supplier\ledger\index.blade.php ENDPATH**/ ?>