<?php $__env->startSection('content'); ?>
<div class="p-4">
    <h2 class="text-3xl font-bold text-gray-800 mb-6">Supplier Ledgers</h2>

    <!-- Search and Filter Form -->
    <form method="GET" action="<?php echo e(route('ledger.show')); ?>" class="mb-6 bg-white p-4 rounded-lg shadow">
        <div class="flex flex-col md:flex-row gap-4">
            <!-- Search Input -->
            <div class="flex-grow">
                <input type="text" name="search" placeholder="Search by supplier name or phone..." 
                       value="<?php echo e(request('search')); ?>"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring focus:ring-blue-200 focus:outline-none">
            </div>

            <!-- Company Filter -->
            <div class="w-full md:w-64">
                <select name="company_filter" class="w-full px-4 py-2 border border-gray-300 rounded-lg">
                    <option value="">All Companies</option>
                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($company->id); ?>" <?php echo e(request('company_filter') == $company->id ? 'selected' : ''); ?>>
                            <?php echo e($company->company_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!-- Buttons -->
            <div class="flex gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                    Filter
                </button>

            <a href="<?php echo e(route('ledger.show', array_merge(request()->except('page'), ['high_ledger' => 1]))); ?>"
               class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700">
                High Ledger
            </a>
        
                <?php if(request('search') || request('company_filter') || request('high_ledger')): ?>
                    <a href="<?php echo e(route('ledger.show')); ?>" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600">
                        Reset
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- High Ledger Button -->
        
    </form>

    <?php if(request('search') && $ledgers->isEmpty()): ?>
        <div class="bg-white p-4 rounded-lg shadow mb-4 text-red-500">
            No results found for "<?php echo e(request('search')); ?>".
        </div>
    <?php endif; ?>

    <!-- Scrollable Table Container -->
    <div class="bg-white rounded-lg shadow overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Image</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Company</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Supplier</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Bill</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php
                    $filteredLedgers = request('high_ledger')
                        ? $ledgers->filter(fn($ledger) => $ledger->due_amount >= 10000)
                        : $ledgers;
                ?>

                <?php $__empty_1 = true; $__currentLoopData = $filteredLedgers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ledger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 <?php echo e($ledger->due_amount >= 10000 ? 'bg-red-100 text-red-800 font-semibold' : ''); ?>">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <?php if($ledger->image): ?>
                            <img src="<?php echo e(asset('storage/' . $ledger->image)); ?>" alt="Supplier Image" class="w-10 h-10 rounded-full object-cover">
                        <?php else: ?>
                            <img src="<?php echo e(asset('images/placeholder.png')); ?>" alt="No Image" class="w-10 h-10 rounded-full object-cover">
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-500"><?php echo e($ledger->id); ?></td>
                    <td class="px-6 py-4 text-sm font-medium text-gray-900">
                        <?php echo e($ledger->company?->company_name ?? 'N/A'); ?>

                    </td>
                    <td class="px-6 py-4 text-sm text-gray-900">
                        <?php echo e($ledger->supplier?->supplier_name ?? 'N/A'); ?>

                    </td>
                    <td class="px-6 py-4 text-sm text-gray-900">
                        <?php echo e(number_format($ledger->total_bill, 2)); ?>

                    </td>
                    <td class="px-6 py-4 text-sm text-green-600">
                        <?php echo e(number_format($ledger->paid_amount, 2)); ?>

                    </td>
                    <td class="px-6 py-4 text-sm">
                        <?php echo e(number_format($ledger->due_amount, 2)); ?>

                    </td>
                    <td class="px-6 py-4 text-sm font-medium">
                        <button onclick="openEditModal(<?php echo e($ledger->id); ?>, <?php echo e($ledger->paid_amount); ?>, <?php echo e($ledger->total_bill); ?>)"
                                class="ml-2 text-yellow-600 hover:text-yellow-800 px-2">Edit</button>
                        <a href="<?php echo e(route('ledger.details', $ledger->id)); ?>" class="text-blue-600 hover:text-blue-900">Details</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="9" class="px-6 py-4 text-center text-sm text-gray-500">No ledger records found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
        <div class="bg-white p-6 rounded-lg shadow-lg w-full max-w-md">
            <h3 class="text-xl font-semibold mb-4">Update Paid Amount</h3>
            <form method="POST" id="editForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="total_bill" id="total_bill">
                <input type="hidden" name="paid_amount" id="paid_amount">

                <div class="mb-4">
                    <label for="new_paid" class="block text-gray-700 mb-1">Enter Paid Amount</label>
                    <input type="number" name="new_paid" id="new_paid" required 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring focus:ring-blue-200 focus:outline-none">
                </div>

                <div class="flex justify-end gap-2">
                    <button type="button" onclick="closeEditModal()" class="px-4 py-2 bg-gray-500 text-white rounded hover:bg-gray-600">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Update</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        <?php echo e($ledgers->appends(request()->query())->links()); ?>

    </div>
</div>

<script>
    function openEditModal(id, paid, total) {
        document.getElementById('editModal').classList.remove('hidden');
        document.getElementById('editForm').action = `/ledger/update/${id}`;
        document.getElementById('total_bill').value = total;
        document.getElementById('paid_amount').value = paid;
    }

    function closeEditModal() {
        document.getElementById('editModal').classList.add('hidden');
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/supplier/ledger/index.blade.php ENDPATH**/ ?>