

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto py-6">
    <h1 class="text-2xl font-bold mb-6">Bill</h1>

    <form action="<?php echo e(route('bill.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <?php $__currentLoopData = $cartWithDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $product = $item['product'];
                $qty = $item['qty'];
            ?>

            <div class="border p-4 rounded mb-6 bg-white shadow-sm">
                <h2 class="text-lg font-semibold mb-2">Product <?php echo e($index + 1); ?></h2>

                <input type="hidden" name="products[<?php echo e($index); ?>][id]" value="<?php echo e($product->id); ?>">
                <input type="hidden" name="products[<?php echo e($index); ?>][qty]" value="<?php echo e($qty); ?>">
                <input type="hidden" name="products[<?php echo e($index); ?>][retail_price]" value="<?php echo e($product->retail_price); ?>">
                <p><strong>Name:</strong> <?php echo e($product->name); ?></p>
                <p><strong>Company:</strong> <?php echo e($product->company); ?></p>
                <p><strong>Salt:</strong> <?php echo e($product->salt); ?></p>
                <p><strong>Category:</strong> 
                    <?php echo e(is_array($product->categories) ? implode(', ', $product->categories) : $product->categories); ?>

                </p>
                <p><strong>Qty:</strong> <?php echo e($qty); ?></p>
                <p><strong>Retail Price:</strong> <?php echo e($product->retail_price); ?></p>

                <div class="mt-2">
                    <label class="block font-medium">Select Price Type:</label>
                    <select 
                        name="products[<?php echo e($index); ?>][price_type]" 
                        class="border p-2 rounded price-select" 
                        data-index="<?php echo e($index); ?>"
                        data-qty="<?php echo e($qty); ?>"
                        data-retail="<?php echo e($product->retail_price); ?>"
                    >
                        <option value="">-- Choose Price --</option>
                        <option value="<?php echo e($product->doctor_price); ?>">Doctor Price (<?php echo e($product->doctor_price); ?>)</option>
                        <option value="<?php echo e($product->local_price); ?>">Local Price (<?php echo e($product->local_price); ?>)</option>
                        <option value="<?php echo e($product->purchase_price); ?>">Purchase Price (<?php echo e($product->purchase_price); ?>)</option>
                    </select>
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Total Amount (price × qty):</label>
                    <input 
                        type="text" 
                        name="products[<?php echo e($index); ?>][total]" 
                        class="border p-2 rounded w-full total-amount" 
                        readonly
                        id="total-amount-<?php echo e($index); ?>"
                    >
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Price Difference (Retail - Selected):</label>
                    <input 
                        type="text" 
                        name="products[<?php echo e($index); ?>][price_diff]" 
                        class="border p-2 rounded w-full price-diff" 
                        readonly
                        id="price-diff-<?php echo e($index); ?>"
                    >
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Total Amount of All Products:</label>
            <input type="text" id="total-amount" name="grand_total" class="border p-2 rounded w-full" readonly>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Print Type:</label>
            <select name="print_type" class="border p-2 rounded w-full">
                <option value="by_name">By Name</option>
                <option value="by_salt">By Salt</option>
            </select>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Remarks:</label>
            <textarea name="remarks" class="border p-2 rounded w-full"></textarea>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Sale Type:</label>
            <select name="sale_type" class="border p-2 rounded w-full">
                <option value="stock">Stock</option>
                <option value="outside">Outside</option>
            </select>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Payment Type:</label>
            <select name="payment_type" id="payment-type" class="border p-2 rounded w-full">
                <option value="cash">Cash</option>
                <option value="credit">Credit</option>
            </select>
        </div>

        
            <div id="credit-info" class="hidden">
                <label>Search Customer:</label>
                <input type="text" id="customer-search" class="border rounded px-2 py-1 w-full" placeholder="Enter name or phone...">
                <input type="hidden" name="customer_id" id="customer_id">
                <div id="customer-suggestions" class="mt-2"></div>

                <div id="new-customer-fields" class="mt-2 hidden">
                    <input type="text" name="new_customer_name" class="border rounded px-2 py-1 w-full mb-2" placeholder="Customer Name">
                    <input type="text" name="new_customer_phone" class="border rounded px-2 py-1 w-full" placeholder="Customer Phone">
                    <input type="text" name="new_customer_address" class="border rounded px-2 py-1 w-full" placeholder="Customer Address">
                
                </div>
            </div>

            
            <div id="cash-info" class="mt-2">
                <input type="text" name="cash_customer_name" class="border rounded px-2 py-1 w-full" placeholder="Customer Name">
            </div>

        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">Submit Bill</button>
    </form>
</div>


<script>
document.querySelectorAll('.price-select').forEach(select => {
    select.addEventListener('change', function () {
        const index = this.dataset.index;
        const qty = parseFloat(this.dataset.qty || 0);
        const retail = parseFloat(this.dataset.retail || 0);
        const selectedPrice = parseFloat(this.value || 0);

        if (!selectedPrice || !qty || !retail) return;

        const total = selectedPrice * qty;
        const diff = retail - selectedPrice;

        const totalInput = document.getElementById(`total-amount-${index}`);
        const diffInput = document.getElementById(`price-diff-${index}`);
        if (totalInput) totalInput.value = total.toFixed(2);
        if (diffInput) diffInput.value = diff.toFixed(2);

        updateTotalAllProducts();
    });
});

function updateTotalAllProducts() {
    let grandTotal = 0;
    document.querySelectorAll('.total-amount').forEach(input => {
        const val = parseFloat(input.value || 0);
        grandTotal += val;
    });
    document.getElementById('total-amount').value = grandTotal.toFixed(2);
}

// Toggle customer fields
document.getElementById('customer-search').addEventListener('input', function () {
    const query = this.value.trim();
    const suggestionBox = document.getElementById('customer-suggestions');
    suggestionBox.innerHTML = '';

    if (query.length >= 2) {
        fetch(`/customers/search?q=${query}`)
            .then(res => res.json())
            .then(data => {
                if (data.length > 0) {
                    data.forEach(cust => {
                        const div = document.createElement('div');
                        div.className = 'p-2 bg-white border cursor-pointer hover:bg-gray-100';
                        div.textContent = `${cust.name} (${cust.phone})`;
                        div.addEventListener('click', () => {
                            document.getElementById('customer_id').value = cust.id;
                            document.getElementById('customer-search').value = `${cust.name} (${cust.phone})`;
                            document.getElementById('new-customer-fields').classList.add('hidden');
                            suggestionBox.innerHTML = '';
                        });
                        suggestionBox.appendChild(div);
                    });
                } else {
                    document.getElementById('new-customer-fields').classList.remove('hidden');
                    document.getElementById('customer_id').value = '';
                }
            });
        }
    });
</script>
<script>
document.getElementById('payment-type').addEventListener('change', function () {
    const creditInfo = document.getElementById('credit-info');
    const cashInfo = document.getElementById('cash-info');

    if (this.value === 'credit') {
        creditInfo.classList.remove('hidden');
        cashInfo.classList.add('hidden');
    } else {
        creditInfo.classList.add('hidden');
        cashInfo.classList.remove('hidden');
    }
});

// On page load, check selected payment type
document.addEventListener('DOMContentLoaded', function () {
    const paymentType = document.getElementById('payment-type');
    const creditInfo = document.getElementById('credit-info');
    const cashInfo = document.getElementById('cash-info');

    if (paymentType.value === 'credit') {
        creditInfo.classList.remove('hidden');
        cashInfo.classList.add('hidden');
    } else {
        creditInfo.classList.add('hidden');
        cashInfo.classList.remove('hidden');
    }
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\bill\create.blade.php ENDPATH**/ ?>