<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto p-6 bg-white shadow rounded-lg">
    <h1 class="text-2xl font-bold mb-6">Print Preview</h1>
    
    <div class="bg-gray-50 p-6 rounded-lg mb-6">
        <!-- Header Preview -->
        <div class="text-center mb-8 p-4 border-b">
            <?php if(isset($printSetting) && $printSetting->logo_path): ?>
                <img src="<?php echo e(asset('storage/' . $printSetting->logo_path)); ?>" alt="Store Logo" class="mx-auto mb-4 h-24">
            <?php endif; ?>
            <h2 class="text-2xl font-bold"><?php echo e($printSetting->title ?? 'Your Store Title'); ?></h2>
            <p class="text-gray-700"><?php echo e($printSetting->address ?? '123 Store Address, City'); ?></p>
            <p class="text-gray-700">Phone: <?php echo e($printSetting->phone ?? '+1234567890'); ?></p>
        </div>

        <!-- Footer Preview -->
        <div class="mt-6 p-4 border-t">
            <p class="text-gray-700 italic"><?php echo e($printSetting->footer_note ?? 'Thank you for shopping with us!'); ?></p>
        </div>

        <!-- Goodbye Preview -->
        <div class="mt-6 text-center p-4">
            <p class="font-semibold"><?php echo e($printSetting->goodbye_message ?? 'Please visit us again!'); ?></p>
        </div>
    </div>

    <div class="flex justify-end">
        <button onclick="openEditModal()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
            <?php echo e(isset($printSetting) ? 'Edit Print Settings' : 'Create Print Settings'); ?>

        </button>
    </div>
</div>

<!-- Edit Modal -->
<div id="editModal" class="fixed inset-0 z-50 hidden overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <!-- Background overlay -->
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>

        <!-- Modal content -->
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
            <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4" id="modal-title">
                    <?php echo e(isset($printSetting) ? 'Edit Print Settings' : 'Create Print Settings'); ?>

                </h3>
               
                 <form id="printSettingsForm" method="POST" action="<?php echo e(route('print.update')); ?>" enctype="multipart/form-data" class="overflow-y-auto max-h-[70vh]">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- Header Section -->
                    <div class="mb-8 p-4 border rounded-lg">
                        <h2 class="text-xl font-semibold mb-4">Header Settings</h2>
                        
                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Logo</label>
                            <?php if(isset($printSetting) && $printSetting->logo_path): ?>
                                <img src="<?php echo e(asset('storage/' . $printSetting->logo_path)); ?>" alt="Current Logo" class="h-20 mb-2">
                            <?php endif; ?>
                            <input type="file" name="logo" class="w-full p-2 border rounded">
                        </div>

                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Store Title</label>
                            <input type="text" name="title" value="<?php echo e($printSetting->title ?? ''); ?>" class="w-full p-2 border rounded" required>
                        </div>

                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Address</label>
                            <textarea name="address" class="w-full p-2 border rounded" rows="2" required><?php echo e($printSetting->address ?? ''); ?></textarea>
                        </div>

                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Phone</label>
                            <input type="text" name="phone" value="<?php echo e($printSetting->phone ?? ''); ?>" class="w-full p-2 border rounded" required>
                        </div>
                    </div>

                    <!-- Footer Section -->
                    <div class="mb-8 p-4 border rounded-lg">
                        <h2 class="text-xl font-semibold mb-4">Footer Settings</h2>
                        
                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Footer Note</label>
                            <textarea name="footer_note" class="w-full p-2 border rounded" rows="3" required><?php echo e($printSetting->footer_note ?? ''); ?></textarea>
                        </div>
                    </div>

                    <!-- Goodbye Section -->
                    <div class="mb-8 p-4 border rounded-lg">
                        <h2 class="text-xl font-semibold mb-4">Goodbye Message</h2>
                        
                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Message</label>
                            <textarea name="goodbye_message" class="w-full p-2 border rounded" rows="2" required><?php echo e($printSetting->goodbye_message ?? ''); ?></textarea>
                        </div>
                    </div>
                </form>
            </div>
            <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                <button type="submit" form="printSettingsForm" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm">
                    <?php echo e(isset($printSetting) ? 'Save Changes' : 'Create Settings'); ?>

                </button>
                <button onclick="closeEditModal()" type="button" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                    Cancel
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    function openEditModal() {
        document.getElementById('editModal').classList.remove('hidden');
        document.body.classList.add('overflow-hidden');
    }

    function closeEditModal() {
        document.getElementById('editModal').classList.add('hidden');
        document.body.classList.remove('overflow-hidden');
    }

    // Close modal when clicking outside
    document.getElementById('editModal').addEventListener('click', function(e) {
        if (e.target === this) {
            closeEditModal();
        }
    });

    // Close modal with Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeEditModal();
        }
    });
</script>

<style>
    .max-h-[70vh] {
        max-height: 70vh;
    }
    .overflow-hidden {
        overflow: hidden;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/printPreview.blade.php ENDPATH**/ ?>