<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Faisal Veterinary Store</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<style>
    /* For printing, hide elements you don't want to show */
    @media print {
            body {
                width: 150mm !important;
                margin: 0 auto !important;
                padding: 0 !important;
            }
            body * {
                visibility: hidden;
            }
            #receipt, #receipt * {
                visibility: visible;
            }
            #receipt {
                width: 100%;
            height: auto;
                margin: 0 auto !important;
                padding: 2mm !important;
                font-family: 'Courier New', monospace !important;
                font-size: 12px !important;
            }
            
            @page {
                size: 150mm auto;
                margin: 0;
            }
        }

    body {
        overflow-x: hidden; /* Prevent horizontal scrolling on the body */
    }

    .main-container {
        display: flex;
        position: relative;
        overflow-x: auto; /* Allow horizontal scrolling on the content */
    }

    .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        width: 16rem;
        z-index: 10;
        height: 100vh;
        overflow-y: auto;
        transition: transform 0.3s ease-in-out;
    }
    .sidebar {
        background-color: #1d3244; /* Dark blue theme */
        color: white;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }
    
    .sidebar a, .sidebar button {
        color: #e5e7eb; /* Light gray text */
        transition: all 0.2s ease;
    }
    
    .sidebar a:hover, .sidebar button:hover {
        background-color: #3b82f6; /* Lighter blue on hover */
        color: white;
    }
    
    .sidebar .py-6 {
        background-color: #1d3244; /* Slightly darker header */
        border-bottom: 1px solid #3b82f6;
    }
    
    .sidebar .text-2xl {
        color: white;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    /* Style buttons, links, and tabs inside the sidebar */
.sidebar button,
.sidebar a,
.sidebar .nav-tab,
.sidebar .tab {
    background-color: #1d3244;
    color: white;
    border: none;
    transition: background-color 0.3s ease, color 0.3s ease;
}

/* Hover effect: slightly lighter theme color */
.sidebar button:hover,
.sidebar a:hover,
.sidebar .nav-tab:hover,
.sidebar .tab:hover {
    background-color: #25425c; /* lighter version of #1d3244 */
    color: white;
}

    /* Icons styling */
    .sidebar-icon {
        width: 1.25rem;
        height: 1.25rem;
        margin-right: 0.75rem;
    }
    
    /* Submenu styling */
    .sidebar .pl-6 {
        border-left: 2px solid #1d3244;
    }
    
    /* Active menu item */
    .sidebar .bg-gray-200 {
        background-color#1d3244 !important;
        color: white !important;
    }
    
    /* Dropdown arrows */
    .sidebar [x-data] svg {
        color: #93c5fd;
    }
    
    /* Mobile menu button */
    .md\:hidden button svg {
        color: #1e3a8a;
    }
    
    /* Dark mode adjustments */
    .dark .sidebar {
        background-color: #1d3244;
    }
    
    .dark .sidebar a, .dark .sidebar button {
        color: #e5e7eb;
    }
    /* Mobile sidebar styles */
    @media (max-width: 767px) {
        .sidebar {
            transform: translateX(-100%);
        }
        
        .sidebar.open {
            transform: translateX(0);
        }
        
        .main-content {
            margin-left: 0 !important;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 9;
        }
        
        .sidebar-overlay.open {
            display: block;
        }
    }

    .main-content {
        margin-left: 16rem; /* Ensure content starts after the sidebar */
        flex: 1;
        padding: 20px;
        background-color: #f5f5f5; /* Light background for the main content */
        overflow-x: auto; /* Allow horizontal scrolling in the main content */
        transition: margin-left 0.3s ease-in-out;
    }
</style>

<body class="font-sans antialiased" x-data="{ sidebarOpen: false }">
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
        <!-- Mobile Hamburger -->
        <div class="md:hidden flex justify-between items-center p-4 bg-white dark:bg-gray-800 shadow">
            <div class="text-xl font-bold text-gray-800 dark:text-white">POS Admin</div>
            <button @click="sidebarOpen = !sidebarOpen" class="focus:outline-none">
                <svg class="w-6 h-6 text-gray-800 dark:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path :class="{ 'hidden': sidebarOpen }" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                    <path :class="{ 'hidden': !sidebarOpen }" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>

        <!-- Sidebar overlay for mobile -->
        <div class="sidebar-overlay" :class="{ 'open': sidebarOpen }" @click="sidebarOpen = false" x-show="sidebarOpen"></div>

        <!-- Sidebar + Content -->
        <div class="main-container">
            <!-- Sidebar -->
           <!-- Sidebar -->
<aside class="sidebar bg-white dark:bg-gray-800 shadow-lg" :class="{ 'open': sidebarOpen }">
   <div class="py-8 flex justify-between items-center border-b dark:border-gray-700">
    <!-- Home Button (left) -->
    <a href="<?php echo e(route('dashboard')); ?>" class="text-xl font-semibold text-gray-800 dark:text-white flex items-center hover:text-blue-600 transition-colors">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 20 20" fill="currentColor">
            <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z" />
        </svg>
        <span class="ml-2">Home</span>
    </a>

    <!-- Make Bill Button (right) -->
    <a href="<?php echo e(route('makeBill')); ?>" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-md text-lg font-semibold flex items-center transition-colors">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z" />
        </svg>
        <span>New Bill</span>
    </a>
</div>
    <nav class="px-4 space-y-4">
        <!-- Medicines Section -->
        <div x-data="{ open: false }" class="space-y-2">
            <button @click="open = !open" class="flex justify-between w-full text-left px-4 py-3 hover:bg-blue-600 rounded-lg items-center">
                <div class="flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M7 2a1 1 0 011 1v1h3a1 1 0 110 2H8v3a1 1 0 11-2 0V6H4a1 1 0 010-2h3V3a1 1 0 011-1zm7 4a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3h-3a1 1 0 110-2h3V7a1 1 0 011-1z" clip-rule="evenodd" />
                    </svg>
                    <span>Manage Products</span>
                </div>
                <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </button>

            <div x-show="open" class="space-y-2 pl-6 rounded-lg">
                <div x-data="{ showOpen: false }" class="space-y-2">
                    <button @click="showOpen = !showOpen" class="flex justify-between w-full text-left px-4 py-3 hover:bg-blue-600 rounded-lg items-center">
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z" />
                                <path fill-rule="evenodd" d="M4 5a2 2 0 012-2 3 3 0 003 3h2a3 3 0 003-3 2 2 0 012 2v11a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm3 4a1 1 0 000 2h.01a1 1 0 100-2H7zm3 0a1 1 0 000 2h3a1 1 0 100-2h-3zm-3 4a1 1 0 100 2h.01a1 1 0 100-2H7zm3 0a1 1 0 100 2h3a1 1 0 100-2h-3z" clip-rule="evenodd" />
                            </svg>
                            <span>Show Products</span>
                        </div>
                        <svg :class="{ 'transform rotate-180': showOpen }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </button>

                    <div x-show="showOpen" class="space-y-2 pl-6 rounded-lg">
                        <a href="<?php echo e(route('product.index', 'in-stock')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            In Stock
                        </a>
                        <a href="<?php echo e(route('product.index', 'out-of-stock')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                            </svg>
                            Out Of Stock
                        </a>
                        <a href="<?php echo e(route('product.index', 'low-stock')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                            Low Stock
                        </a>
                        <a href="<?php echo e(route('product.index', 'near-expiry')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                            </svg>
                            Near Expiry
                        </a>
                    </div>
                </div>
                <a href="<?php echo e(route('product.create')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" />
                    </svg>
                    Add Product
                </a>
                <a href="<?php echo e(route('return')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M7.707 3.293a1 1 0 010 1.414L5.414 7H11a7 7 0 017 7v2a1 1 0 11-2 0v-2a5 5 0 00-5-5H5.414l2.293 2.293a1 1 0 11-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" />
                    </svg>
                    Return Product
                </a>
            </div>
        </div>

        <!-- Sales Report Section -->
        <div x-data="{ open: false }" class="space-y-2">
            <button @click="open = !open" class="flex justify-between w-full text-left px-4 py-3 hover:bg-blue-600 rounded-lg items-center">
                <div class="flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path d="M2 11a1 1 0 011-1h2a1 1 0 011 1v5a1 1 0 01-1 1H3a1 1 0 01-1-1v-5zM8 7a1 1 0 011-1h2a1 1 0 011 1v9a1 1 0 01-1 1H9a1 1 0 01-1-1V7zM14 4a1 1 0 011-1h2a1 1 0 011 1v12a1 1 0 01-1 1h-2a1 1 0 01-1-1V4z" />
                    </svg>
                    <span>Sales Report</span>
                </div>
                <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </button>
            <div x-show="open" class="space-y-2 pl-6 rounded-lg">
                <a href="<?php echo e(route('sale')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 2a4 4 0 00-4 4v1H5a1 1 0 00-.994.89l-1 9A1 1 0 004 18h12a1 1 0 00.994-1.11l-1-9A1 1 0 0015 7h-1V6a4 4 0 00-4-4zm2 5V6a2 2 0 10-4 0v1h4zm-6 3a1 1 0 112 0 1 1 0 01-2 0zm7-1a1 1 0 100 2 1 1 0 000-2z" clip-rule="evenodd" />
                    </svg>
                    Product Sales
                </a>
                <a href="<?php echo e(route('sales.report')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z" />
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clip-rule="evenodd" />
                    </svg>
                    Total Cash-In
                </a>
                <a href="<?php echo e(route('cash-out')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4z" />
                        <path fill-rule="evenodd" d="M18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z" clip-rule="evenodd" />
                    </svg>
                    Total Cash-Out
                </a>
                <a href="<?php echo e(route('product.lowSales')); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2h-1V9z" clip-rule="evenodd" />
                    </svg>
                    Low Sales Product
                </a>
            </div>
        </div>

        <!-- Manage Bill Section -->
        <div x-data="{ open: false }" class="space-y-2">
            <button @click="open = !open" class="flex justify-between w-full text-left px-4 py-3 hover:bg-blue-600 rounded-lg items-center">
                <div class="flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M5 4a1 1 0 00-1 1v14a1 1 0 001 1h10a1 1 0 001-1V5a1 1 0 00-1-1H5zm2 6a1 1 0 011-1h4a1 1 0 110 2H8a1 1 0 01-1-1zm1 3a1 1 0 100 2h4a1 1 0 100-2H8z" clip-rule="evenodd" />
                    </svg>
                    <span>Manage Bill</span>
                </div>
                <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </button>
            <div x-show="open" class="space-y-2 pl-6 rounded-lg">
               
                <a href="<?php echo e(route('bill.details', ['status' => 'completed'])); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                    </svg>
                    Completed Bills
                </a>
                <a href="<?php echo e(route('bill.details', ['status' => 'pending'])); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                    </svg>
                    Pending Bills
                </a>
                <a href="<?php echo e(route('outside-bills.index', ['status' => 'completed'])); ?>" class="block hover:bg-blue-600 px-4 py-2 rounded-md flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                    </svg>
                    Outside Bills
                </a>
            </div>
        </div>
 <!-- Credit Accounts Section -->
                   <!-- Manage Credit Accounts -->
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        <span class="flex items-center gap-2">
            <!-- Credit Card Icon -->
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path d="M2.25 6.75h19.5v10.5H2.25V6.75zM2.25 9.75h19.5" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            Manage Credit Accounts
        </span>
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
        <a href="<?php echo e(route('credit.show')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">View Credit Accounts</a>
        <a href="<?php echo e(route('credit.create')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Create New Credit</a>
        <a href="<?php echo e(route('credit.report')); ?>" class="block text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-700 px-4 py-3 rounded-lg">Credit Date to Date</a>
    </div>
</div>

<!-- Manage Companies -->
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        <span class="flex items-center gap-2">
            <!-- Office Building Icon -->
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path d="M3 21h18M9 21V3h6v18M9 8h6" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            Manage Companies
        </span>
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
        <a href="<?php echo e(route('company.show')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">View Company</a>
        <a href="<?php echo e(route('company.form')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Create New Company</a>
    </div>
</div>

<!-- Manage Demands -->
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        <span class="flex items-center gap-2">
            <!-- Clipboard Document Icon -->
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path d="M16 4H8v2H5.5A1.5 1.5 0 004 7.5v12A1.5 1.5 0 005.5 21h13a1.5 1.5 0 001.5-1.5v-12A1.5 1.5 0 0018.5 6H16V4z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            Manage Demands
        </span>
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
        <a href="<?php echo e(route('demand.show')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">View Demands</a>
        <a href="<?php echo e(route('demand.form')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Add Demand</a>
    </div>
</div>

<!-- Supplier Ledger -->
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        <span class="flex items-center gap-2">
            <!-- Document Text Icon -->
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path d="M12 20h9M3 4h18M3 8h18M3 12h9m0 4H3" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            Supplier Ledger
        </span>
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
        <a href="<?php echo e(route('supplier.form')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Add New Supplier</a>
        <a href="<?php echo e(route('supplier.show')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Show Supplier</a>
        <a href="<?php echo e(route('ledger.form')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Create New Ledger</a>
        <a href="<?php echo e(route('ledger.show')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">All Ledger</a>
    </div>
</div>

<!-- Extra Expense -->
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        <span class="flex items-center gap-2">
            <!-- Receipt Icon -->
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path d="M6 9h12M6 13h8m-6 4h6M5 3h14v18l-2-2-2 2-2-2-2 2-2-2-2 2V3z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            Extra Expense
        </span>
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
        <a href="<?php echo e(route('expense.form')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Add Extra Expense</a>
        <a href="<?php echo e(route('extra_expenses.index')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">All Extra Expenses</a>
    </div>
</div>

<!-- Profit Report -->
<a href="<?php echo e(route('reports.profit')); ?>" class="flex items-center gap-2 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-700 px-4 py-3 rounded-lg">
    <!-- Chart Bar Icon -->
    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path d="M4 20h16M9 16v-4M15 20V10M12 20v-6" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
    Profit Report
</a>

<!-- NotePad -->
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        <span class="flex items-center gap-2">
            <!-- Pencil Square Icon -->
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path d="M16.862 3.487a2.1 2.1 0 113 2.961L7.5 18.809l-4.5 1.5 1.5-4.5L16.862 3.487z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            NotePad
        </span>
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
        <a href="<?php echo e(route('note.view')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Create A Note</a>
        <a href="<?php echo e(route('note.show')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">View Notes</a>
    </div>
</div>
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        <span class="flex items-center gap-2">
            <!-- Pencil Square Icon -->
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path d="M16.862 3.487a2.1 2.1 0 113 2.961L7.5 18.809l-4.5 1.5 1.5-4.5L16.862 3.487z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            Receipt
        </span>
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
        <a href="<?php echo e(route('receipt.form')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Create A Receipt</a>
        <a href="<?php echo e(route('receipt.index')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Pending Reports</a>
         <a href="<?php echo e(route('receipt.complete')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2">Completed Reports</a>
    </div>
</div>
<div x-data="{ open: false }" class="space-y-2">
    <button @click="open = !open" class="flex items-center justify-between w-full text-left px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-200 rounded-lg">
        
            <!-- Pencil Square Icon -->
             <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd" />
                </svg>
           <span>Print Settings</span>
       
        <svg :class="{ 'transform rotate-180': open }" class="w-4 h-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path d="M19 9l-7 7-7-7" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
    </button>
    <div x-show="open" class="space-y-2 pl-6 rounded-lg">
         <a href="<?php echo e(route('print.preview')); ?>" class="flex items-center px-4 py-3 hover:bg-blue-600 rounded-lg">
               
                Bill Print Setting
            </a>
        <a href="<?php echo e(route('receipt-print.preview')); ?>" class="block text-gray-600 dark:text-gray-400 bg-gray-200 dark:hover:bg-gray-800 px-4 py-2"> Receipt Print Setting</a>
        
    </div>
</div>

        <!-- Bottom menu items (Logout and Profile) -->
        <div class="space-y-2 mt-8 border-t border-blue-800 pt-4">
<a href="<?php echo e(route('counter.close.summary')); ?>" class="flex items-center px-4 py-3 hover:bg-blue-600 rounded-lg">
     <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 00-1 1v12a1 1 0 102 0V4a1 1 0 00-1-1zm10.293 9.293a1 1 0 001.414 1.414l3-3a1 1 0 000-1.414l-3-3a1 1 0 10-1.414 1.414L14.586 9H7a1 1 0 100 2h7.586l-1.293 1.293z" clip-rule="evenodd" />
                    </svg>
                
                <span>Close Counter</span>
            </a>
            <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="flex items-center w-full text-left px-4 py-3 hover:bg-blue-600 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 00-1 1v12a1 1 0 102 0V4a1 1 0 00-1-1zm10.293 9.293a1 1 0 001.414 1.414l3-3a1 1 0 000-1.414l-3-3a1 1 0 10-1.414 1.414L14.586 9H7a1 1 0 100 2h7.586l-1.293 1.293z" clip-rule="evenodd" />
                    </svg>
                    <span>Logout</span>
                </button>
            </form>
            <a href="<?php echo e(route('profile')); ?>" class="flex items-center px-4 py-3 hover:bg-blue-600 rounded-lg">
                <svg xmlns="http://www.w3.org/2000/svg" class="sidebar-icon" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd" />
                </svg>
                <span>Profile Settings</span>
            </a>
           <form action="<?php echo e(route('system.reset')); ?>" method="POST" onsubmit="return confirmReset()">
    <?php echo csrf_field(); ?>
    <button type="submit" class="flex items-center gap-2 bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600">
        <!-- Refresh/Reset Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                  d="M4 4v5h.582m15.356 1A9.003 9.003 0 006.582 9M20 20v-5h-.581m-15.357-1a9.003 9.003 0 0013.776 3.998" />
        </svg>
        <span>Reset System</span>
    </button>
</form>


        </div>
    </nav>
</aside>

            <!-- Main Content Area -->
            <main class="main-content">
                <?php echo $__env->yieldContent('content'); ?>
                <?php echo $__env->yieldContent('scripts'); ?>
            </main>
        </div>
    </div>
    <script>
    function setPrintMode(detailed) {
        const header = document.getElementById('storeHeader');
        const footer = document.getElementById('storeFooter');
        const goodbye = document.getElementById('goodbye');

        if (detailed) {
            header.style.display = 'block';
            footer.style.display = 'block';
            goodbye.style.display = 'block';
        } else {
            header.style.display = 'none';
        }
    }

    function handlePrint(billId, currentStatus) {
        if (currentStatus === 'pending') {
            fetch(`/bills/${billId}/mark-complete`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({})
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    window.print();
                } else {
                    alert('Failed to update status.');
                }
            })
            .catch(error => {
                alert('Error updating bill status.');
                console.error(error);
            });
        } else {
            window.print();
        }
    }
     function confirmReset() {
    const attempts = <?php echo e(session('reset_attempts', 0 )); ?>;
    const remaining = 5 - attempts;
    
    if (remaining > 0) {
        return confirm(`This is attempt ${attempts + 1} of 5. You'll need to login ${remaining} more time(s) after this to complete the reset. Continue?`);
    }
    return confirm('WARNING! This will delete ALL data except user accounts. Are you absolutely sure?');
}
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/layouts/app.blade.php ENDPATH**/ ?>