

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Animal Receipts</h1>
        
        <!-- Search Bar -->
        <div class="w-full md:w-1/3 mt-4 md:mt-0">
            <form action="<?php echo e(route('receipt.complete')); ?>" method="GET">
                <div class="relative">
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                           class="w-full pl-10 pr-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                           placeholder="Search by Patient No, Contact, Farmer...">
                    <div class="absolute left-3 top-2.5">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Table Container -->
    <div class="bg-white shadow-md rounded-lg overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Patient No</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Farmer Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Animal</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Animal Tag No</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reffered By</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Gender</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Contact</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Finding</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Image</th>
                    
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($receipt->patient_no); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($receipt->date); ?> <?php echo e($receipt->time); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($receipt->farmer_name); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize"><?php echo e($receipt->animal); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize"><?php echo e($receipt->animal_tag_no); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize"><?php echo e($receipt->referred_by); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize"><?php echo e($receipt->gender); ?></td>  
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($receipt->contact_no); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($receipt->finding); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php if(!empty($receipt->image)): ?>
   
        <img src="<?php echo e(Storage::url($receipt->image)); ?>" 
     alt="Receipt Image" 
     class="max-w-md w-full h-auto rounded shadow-md border border-gray-300">
   
<?php endif; ?>
</td>
                    
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                         <a href="<?php echo e(route('receipt.completeprint', $receipt->id)); ?>" class="text-green-600 hover:text-green-900" >Print</a>
                                   
                        <form action="<?php echo e(route('receipt.destroy', $receipt->id)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:text-red-900" 
                                    onclick="return confirm('Are you sure you want to delete this receipt?')">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        <?php echo e($receipts->links()); ?>

    </div>
</div>

<!-- Edit Modal -->


<script>
   
    
    
</script>

<style>
    /* Make table scrollable on small screens */
    @media (max-width: 640px) {
        .overflow-x-auto {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/receipt/complete.blade.php ENDPATH**/ ?>