

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">
    
    <div id="receipt">
        <!-- Header Section -->
        <div id="storeHeader" class="text-center mb-6">
            <img src="<?php echo e(asset('images/logo.png')); ?>" alt="Faisal Veterinary Store Logo" class="mx-auto mb-4" style="max-width: 150px; height: auto;">
            <h1 class="text-3xl font-bold">Faisal Veterinary Store</h1>
            <p class="text-sm text-gray-700">Liaqat Road Near Tasty Hotel, Mian Channu</p>
            <p class="text-sm text-gray-700">Phone: 0333-4114499</p>
        </div>

        <!-- All Products Table -->
        <div class="mb-6">
            <h2 class="text-xl font-semibold mb-2 text-center">All Products</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-left border">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border px-4 py-2">#</th>
                            <th class="border px-4 py-2">Name</th>
                            <th class="border px-4 py-2">Type</th>
                            <th class="border px-4 py-2">Category</th>
                            <th class="border px-4 py-2">Salt</th>
                            <th class="border px-4 py-2 price-col">Local Price</th>
                            <th class="border px-4 py-2 price-col">Retail Price</th>
                            <th class="border px-4 py-2 price-col">Doctor Price</th>
                            <th class="border px-4 py-2 price-col">Purchase Price</th>
                            <th class="border px-4 py-2">Quantity</th>
                            <th class="border px-4 py-2">Unit Type</th>
                            <th class="border px-4 py-2">Expiry Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $grandTotal = 0; ?>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="border px-4 py-2"><?php echo e($index + 1); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->name); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->type); ?></td>
                                <td class="border px-4 py-2">  <?php $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="inline-block bg-gray-200 text-gray-800 text-xs px-2 py-1 rounded mr-1"><?php echo e($category); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->salt); ?></td>
                                <td class="border px-4 py-2 price-col">Rs. <?php echo e($product->local_price ?? '0'); ?></td>
                                <td class="border px-4 py-2 price-col">Rs. <?php echo e($product->retail_price ?? '0'); ?></td>
                                <td class="border px-4 py-2 price-col">Rs. <?php echo e($product->doctor_price ?? '0'); ?></td>
                                <td class="border px-4 py-2 price-col">Rs. <?php echo e($product->purchase_price ?? '0'); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->quantity); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->unit_type); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->expiry_date); ?></td>
                            </tr>

                            <?php
                                $grandTotal += $product->retail_price ?? 0;
                            ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <!-- Show total only if prices are visible -->
                <div id="totalPrice" class="mt-4 text-right font-bold text-lg price-col">
                    Total Retail Price: Rs. <?php echo e($grandTotal); ?>

                </div>
            </div>
        </div>

        <!-- Footer -->
        <div id="storeFooter" class="mt-6 text-sm text-gray-700 text-center">
            <p><strong>Note:</strong> We offer a wide range of veterinary medicines and animal health products.</p>
            <p class="mt-4 font-semibold">Thank you for visiting Faisal Veterinary Store!</p>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="mt-6 flex justify-center space-x-4 print:hidden">
        <button onclick="togglePrice(true)" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Print With Price
        </button>
        <button onclick="togglePrice(false)" class="bg-gray-700 hover:bg-gray-800 text-white px-4 py-2 rounded">
            Print Without Price
        </button>
    </div>
</div>

<!-- JS: Toggle Price Columns -->
<script>
    function togglePrice(show) {
        const priceCols = document.querySelectorAll('.price-col');
        const totalPrice = document.getElementById('totalPrice');
        
        priceCols.forEach(col => {
            col.style.display = show ? 'table-cell' : 'none';
        });

        if (totalPrice) {
            totalPrice.style.display = show ? 'block' : 'none';
        }

        window.print();
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\product\print.blade.php ENDPATH**/ ?>