

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-4 py-6">

    <h1 class="text-2xl font-bold mb-4 text-center">Search Product for Bill</h1>

    
    <form method="GET" action="<?php echo e(route('products.search')); ?>" class="mb-6">
        <div class="flex flex-col sm:flex-row gap-2">
            <input type="text" name="q" value="<?php echo e(old('q', $query ?? '')); ?>" required
                placeholder="Search by name, salt, category, company, type..."
                class="flex-1 border border-gray-300 rounded p-2 w-full" />
                <input type="hidden" name="view" value="bill.makeBill">
            <button type="submit"
                class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                Search
            </button>
        </div>
    </form>

    
    <?php if(isset($products)): ?>
        <h2 class="text-lg font-semibold mb-3">Search Results</h2>
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3 mb-6">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="border p-4 rounded shadow bg-white">
                    <p class="font-bold text-lg"><?php echo e($product->name); ?></p>
                    <p class="text-sm text-gray-500">Company: <?php echo e($product->company); ?></p>
                    <p class="text-sm text-gray-500">
                        Category:
                        <?php $__currentLoopData = (is_array($product->categories) ? $product->categories : json_decode($product->categories, true) ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="inline-block bg-gray-200 text-gray-700 px-2 py-1 rounded mr-1"><?php echo e($category); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </p>
                    <p class="text-sm text-gray-500">Salt: <?php echo e($product->salt); ?></p>
                    <p class="text-sm text-gray-500">Unit Type: <?php echo e($product->unit_type); ?></p>
                    <p class="text-sm text-gray-500">Stock: <?php echo e($product->quantity); ?> left</p>

                    <?php
                        $productJson = json_encode([
                            'id' => $product->id,
                            'name' => $product->name,
                            'company' => $product->company,
                            'unit_type' => $product->unit_type,
                            'salt' => $product->salt,
                            'stock' => $product->quantity,
                            'category' => is_array($product->categories) ? implode(', ', $product->categories) : $product->categories,
                        ]);
                    ?>

                    <button type="button"
                        onclick='addToCart(<?php echo $productJson; ?>)'
                        class="mt-3 bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700 w-full">
                        Add to Bill
                    </button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    
    <h2 class="text-xl font-semibold mb-3">Cart</h2>
    <form method="POST" action="<?php echo e(route('cart.submit')); ?>" id="bill-form">
        <?php echo csrf_field(); ?>
        <div id="cart-container" class="space-y-4"></div>

        <button type="submit"
            class="mt-4 bg-indigo-600 text-white px-6 py-2 rounded hover:bg-indigo-700 hidden"
            id="submit-btn">
            Submit Bill
        </button>
    </form>

</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
    let cart = JSON.parse(localStorage.getItem('cart')) || [];

    function saveCart() {
        localStorage.setItem('cart', JSON.stringify(cart));
    }

    function addToCart(product) {
        const exists = cart.find(p => p.id === product.id);
        if (exists) {
            alert('Product already in cart!');
            return;
        }

        cart.push(product);
        saveCart();
        renderCart();
    }

    function removeFromCart(productId) {
        cart = cart.filter(p => p.id !== productId);
        saveCart();
        renderCart();
    }

    function renderCart() {
        const container = document.getElementById('cart-container');
        container.innerHTML = '';
        if (cart.length === 0) {
            document.getElementById('submit-btn').classList.add('hidden');
            return;
        }
        document.getElementById('submit-btn').classList.remove('hidden');
        document.getElementById('bill-form')?.addEventListener('submit', function () {
    localStorage.removeItem('cart');
});

        cart.forEach((product, index) => {
            const item = document.createElement('div');
            item.className = 'p-4 border rounded bg-gray-50 shadow flex flex-col sm:flex-row justify-between items-center gap-2';
            item.innerHTML = `
                <div>
                    <input type="hidden" name="products[${index}][product_id]" value="${product.id}">
                    <p class="font-bold">${product.name}</p>
                    <p class="text-sm text-gray-500">${product.company} | ${product.category}</p>
                    <p class="text-sm text-gray-500">Salt: ${product.salt} | Unit: ${product.unit_type}</p>
                </div>
                <div class="flex items-center gap-2">
                    <label class="text-sm">Qty:</label>
                    <input type="number" name="products[${index}][qty]" value="1" min="1" class="w-20 p-1 border rounded">
                    <button type="button" onclick="removeFromCart(${product.id})"
                        class="text-red-600 text-sm hover:underline">Remove</button>
                </div>
            `;
            container.appendChild(item);
        });
    }

    // Render cart on page load
    document.addEventListener("DOMContentLoaded", renderCart);
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\bill\makeBill.blade.php ENDPATH**/ ?>