<?php $__env->startSection('content'); ?>
<div class="p-4">
    <h2 class="text-3xl font-bold text-gray-800 mb-6">All Products Demand</h2>

    <!-- Company Filter Scrollbar -->
    <div class="mb-6 pb-2 overflow-x-auto">
        <div class="flex space-x-2 w-full">
            <!-- All Companies Button -->
            <button onclick="filterDemands('all')" 
                    class="filter-btn px-4 py-2 rounded-full bg-blue-600 text-white whitespace-nowrap hover:bg-blue-700 transition-all duration-200">
                All Companies
            </button>
            
            <!-- Individual Company Buttons -->
            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button onclick="filterDemands('<?php echo e($company); ?>')" 
                        class="filter-btn px-4 py-2 rounded-full bg-gray-200 text-gray-800 whitespace-nowrap hover:bg-gray-300 transition-all duration-200"
                        data-company="<?php echo e($company); ?>">
                    <?php echo e($company); ?>

                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Left Section: Search + Table -->
        <div class="lg:col-span-2">
            <!-- Search Form -->
            <form method="GET" action="<?php echo e(route('demand.show')); ?>" class="mb-6" id="searchForm">
                <input type="hidden" name="company_filter" id="companyFilterInput" value="<?php echo e(request('company_filter')); ?>">
                <div class="flex items-center space-x-2">
                    <input type="text" name="search" placeholder="Search by product, company or supplier..." value="<?php echo e(request('search')); ?>"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-200 focus:outline-none" />
                    <button type="submit"
                        class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                        Search
                    </button>
                    <?php if(request('search') || request('company_filter')): ?>
                    <a href="<?php echo e(route('demand.show')); ?>" 
                       class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-200">
                        Clear
                    </a>
                    <?php endif; ?>
                </div>
            </form>

            <?php if(request('search') && $demands->isEmpty()): ?>
                <div class="text-red-500 mb-4">No results found for "<?php echo e(request('search')); ?>".</div>
            <?php endif; ?>

            <!-- Table -->
            <div class="w-full overflow-x-auto">
                <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap shadow-lg rounded-lg overflow-hidden">
                    <thead class="bg-gray-200 text-gray-700">
                        <tr>
                            <th class="px-4 py-2">ID</th>
                            <th class="px-4 py-2">Product Name</th>
                            <th class="px-4 py-2">Company Name</th>
                            <th class="px-4 py-2">Supplier Name</th>
                            <th class="px-4 py-2">Quantity</th>
                            <th class="px-4 py-2">Reminder</th>
                            <th class="px-4 py-2">Actions</th>
                        </tr>
                    </thead>
                    <tbody id="demandsTableBody">
                        <?php $__empty_1 = true; $__currentLoopData = $demands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $demand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-b hover:bg-gray-50" data-company="<?php echo e($demand->company_name); ?>">
                                <td class="px-4 py-2"><?php echo e($demand->id); ?></td>
                                <td class="px-4 py-2"><?php echo e($demand->product_name); ?></td>
                                <td class="px-4 py-2"><?php echo e($demand->company_name); ?></td>
                                <td class="px-4 py-2"><?php echo e($demand->supplier_name); ?></td>
                                <td class="px-4 py-2"><?php echo e($demand->qty); ?></td>
                                <td class="px-4 py-2"><?php echo e($demand->reminder); ?></td>
                                <td class="px-4 py-2 space-x-2">
                                    <button
                                        onclick="openModal(this)"
                                        class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600"
                                        data-id="<?php echo e($demand->id); ?>"
                                        data-name="<?php echo e($demand->product_name); ?>"
                                        data-cname="<?php echo e($demand->company_name); ?>"
                                        data-supplier="<?php echo e($demand->supplier_name); ?>"
                                        data-qty="<?php echo e($demand->qty); ?>"
                                        data-reminder="<?php echo e($demand->reminder); ?>"
                                    >
                                        Edit
                                    </button>

                                    <form action="<?php echo e(route('demand.delete', $demand->id)); ?>" method="POST" class="inline-block">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center text-gray-500 py-4">No records found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Right Section: Note Pad -->
        <div class="bg-yellow-100 rounded-xl shadow-md p-6">
            <h3 class="text-xl font-semibold text-gray-800 mb-4">📝 Add a Note</h3>
            <form method="POST" action="<?php echo e(route('note.create')); ?>">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Note Title</label>
                    <input type="text" name="title" placeholder="e.g. Follow up with supplier"
                        class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:ring focus:ring-yellow-300" required />
                </div>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Note</label>
                    <textarea name="note" rows="6" placeholder="Type your note here..."
                        class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:ring focus:ring-yellow-300 resize-none" required></textarea>
                </div>
                <button type="submit" class="bg-yellow-500 text-white px-6 py-2 rounded hover:bg-yellow-600 transition duration-200 w-full">
                    Save Note
                </button>
            </form>
        </div>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-40">
        <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl relative">
            <button onclick="closeModal()"
                    class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-2xl font-bold">
                &times;
            </button>
            <h3 class="text-xl font-semibold mb-4 text-gray-800">Update Demand</h3>

            <form id="editForm" method="POST" action="">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Product Name</label>
                    <input type="text" name="product_name" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Company Name</label>
                    <input type="text" name="company_name" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Supplier Name</label>
                    <input type="text" name="supplier_name" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Quantity</label>
                    <input type="number" name="quantity" value=""
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Reminder</label>
                    <input type="datetime-local" name="reminder" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700 transition duration-200">
                    Update
                </button>
            </form>
        </div>
    </div>
</div>

<style>
    .filter-btn {
        transition: all 0.3s ease;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .filter-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 6px rgba(0,0,0,0.15);
    }
    .filter-btn.active {
        background-color: #2563eb;
        color: white;
        font-weight: 600;
    }
</style>

<script>
    // Filter demands by company
    function filterDemands(companyName) {
        // Update active button
        document.querySelectorAll('.filter-btn').forEach(btn => {
            btn.classList.remove('active', 'bg-blue-600', 'text-white');
            btn.classList.add('bg-gray-200', 'text-gray-800');
        });
        
        // Set active button
        if (companyName === 'all') {
            document.querySelector('.filter-btn:first-child').classList.add('active', 'bg-blue-600', 'text-white');
        } else {
            document.querySelector(`.filter-btn[data-company="${companyName}"]`).classList.add('active', 'bg-blue-600', 'text-white');
        }
        
        // Set hidden input for form submission
        document.getElementById('companyFilterInput').value = companyName === 'all' ? '' : companyName;
        
        // Clear search input when changing filters
        document.querySelector('[name="search"]').value = '';
        
        // Submit the form to refresh with filtered results
        document.getElementById('searchForm').submit();
    }

    // Initialize active filter button based on current filter
    document.addEventListener('DOMContentLoaded', function() {
        const currentFilter = "<?php echo e(request('company_filter')); ?>";
        if (currentFilter) {
            document.querySelector(`.filter-btn[data-company="${currentFilter}"]`).classList.add('active', 'bg-blue-600', 'text-white');
        } else {
            document.querySelector('.filter-btn:first-child').classList.add('active', 'bg-blue-600', 'text-white');
        }
    });

    // Modal functions
    function openModal(button) {
        const modal = document.getElementById('editModal');
        const form = document.getElementById('editForm');

        const demandId = button.getAttribute('data-id');
        form.action = `/demand/update/${demandId}`;
        form.querySelector('[name="product_name"]').value = button.getAttribute('data-name');
        form.querySelector('[name="company_name"]').value = button.getAttribute('data-cname');
        form.querySelector('[name="supplier_name"]').value = button.getAttribute('data-supplier');
        form.querySelector('[name="quantity"]').value = button.getAttribute('data-qty');
        form.querySelector('[name="reminder"]').value = button.getAttribute('data-reminder');

        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    function closeModal() {
        const modal = document.getElementById('editModal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/demand/index.blade.php ENDPATH**/ ?>