

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">
    
    <div id="receipt">
    <!-- Header Section -->
<div id="storeHeader" class="text-center mb-6">
    <img src="<?php echo e(asset('images/logo.png')); ?>" alt="Faisal Veterinary Store Logo" class="mx-auto mb-4" style="max-width: 150px; height: auto;">
    <h1 class="text-3xl font-bold">Faisal Veterinary Store</h1>
    <p class="text-sm text-gray-700">Liaqat Road NEar Tasty Hotel Mian Channu</p>
    <p class="text-sm text-gray-700">Phone: 0333-4114499</p>
</div>

    <!-- Bill Details Section -->
    <div class="border-t border-b py-4 mb-4">
        <div class="flex justify-between mb-2">
            <span class="font-semibold">Bill ID:</span>
            <span><?php echo e($bill->id); ?></span>
        </div>
        <div class="flex justify-between mb-2">
            <span class="font-semibold">Customer Name:</span>
            <span><?php echo e($bill->customer_name ?? 'N/A'); ?></span>
        </div>
        <div class="flex justify-between mb-2">
            <span class="font-semibold">Date:</span>
            <span><?php echo e($bill->date); ?></span>
        </div>
        <div class="flex justify-between mb-2">
            <span class="font-semibold">Payment Type:</span>
            <span><?php echo e($bill->payment); ?></span>
        </div>
        <div class="flex justify-between mb-2">
            <span class="font-semibold">Total Amount:</span>
            <span>Rs. <?php echo e($bill->total_amount); ?></span>
        </div>
    </div>

    <!-- Product Table -->
    <div class="mb-6">
        <h2 class="text-lg font-semibold mb-2">Bill Items</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm text-left border">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border px-4 py-2">#</th>
                        <th class="border px-4 py-2">Product</th>
                        <th class="border px-4 py-2">Quantity</th>
                        <th class="border px-4 py-2">Unit Price</th>
                        <th class="border px-4 py-2">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="border px-4 py-2"><?php echo e($index + 1); ?></td>
                            <td class="border px-4 py-2">
    <?php if($bill->print_type === 'by_salt'): ?>
        <?php echo e($item->product->salt ?? 'N/A'); ?>

    <?php else: ?>
        <?php echo e($item->product->name ?? 'N/A'); ?>

    <?php endif; ?>
</td>

                            <td class="border px-4 py-2"><?php echo e($item->qty); ?></td>
                            <td class="border px-4 py-2">Rs. <?php echo e($item->retail_price); ?></td>
                            <td class="border px-4 py-2">Rs. <?php echo e($item->amount); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Footer Info Section -->
<div id="storeFooter" class="mt-6 text-sm text-gray-700">
    <p><strong>Note:</strong> We also offer a wide range of veterinary products including medicines, food supplements, and animal care items.</p>
</div>

<!-- Goodbye Message -->
<div id="goodbye" class="mt-6 text-center font-semibold">
    <p>Thank you for visiting My Veterinary Store!</p>
    <p>We hope to see you again.</p>
</div>
</div>
   <!-- Buttons -->
<div class="mt-6 flex justify-center space-x-4 print:hidden">
    <button onclick="setPrintMode(true)" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
        Detailed Print
    </button>
    <button onclick="setPrintMode(false)" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded">
        Simple Print
    </button>
    <button onclick="handlePrint(<?php echo e($bill->id); ?>, '<?php echo e($bill->status); ?>')" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
    Print
</button>

    <a href="<?php echo e(route('bill.pending', $bill->id)); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">
        Pending
    </a>
</div>


</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\bill\print-view.blade.php ENDPATH**/ ?>